'use strict';

var React = require('react');

/**
 * Backdrop for modals, dropdown, popover.
 *
 *
 * For example:
 *
 * <Backdrop onClose={onClosePopover}>
 *      <Popover>...</Popover>
 * </Backdrop>
 */
var Backdrop = React.createClass({
    displayName: 'Backdrop',

    propTypes: {
        // Close on escape
        escape: React.PropTypes.bool,
        // Z-index for the backdrop
        zIndex: React.PropTypes.number,
        // Callback when backdrop is closed
        onClose: React.PropTypes.func.isRequired,
        children: React.PropTypes.node.isRequired,
        wrapper: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            escape: true,
            zIndex: 200,
            wrapper: React.createElement('div', null)
        };
    },
    onClose: function onClose() {
        var onClose = this.props.onClose;

        onClose();
    },
    onClick: function onClick(event) {
        event.stopPropagation();
        event.preventDefault();
        this.onClose();
    },
    onKeyDown: function onKeyDown(event) {
        var escape = this.props.escape;


        if (event.keyCode === 27 && escape) {
            this.onClose();
        }
    },
    componentDidMount: function componentDidMount() {
        window.addEventListener('keydown', this.onKeyDown);
    },
    componentWillUnmount: function componentWillUnmount() {
        window.removeEventListener('keydown', this.onKeyDown);
    },
    render: function render() {
        var _props = this.props,
            zIndex = _props.zIndex,
            wrapper = _props.wrapper,
            children = _props.children;

        var style = {
            zIndex: zIndex,
            position: 'fixed',
            top: 0,
            right: 0,
            width: '100%',
            height: '100%'
        };

        return React.cloneElement(wrapper, {}, React.createElement('div', { style: style, onClick: this.onClick }), wrapper.props.children, children);
    }
});

module.exports = Backdrop;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uL3NyYy9CYWNrZHJvcC5qcyJdLCJuYW1lcyI6WyJSZWFjdCIsInJlcXVpcmUiLCJCYWNrZHJvcCIsImNyZWF0ZUNsYXNzIiwicHJvcFR5cGVzIiwiZXNjYXBlIiwiUHJvcFR5cGVzIiwiYm9vbCIsInpJbmRleCIsIm51bWJlciIsIm9uQ2xvc2UiLCJmdW5jIiwiaXNSZXF1aXJlZCIsImNoaWxkcmVuIiwibm9kZSIsIndyYXBwZXIiLCJnZXREZWZhdWx0UHJvcHMiLCJwcm9wcyIsIm9uQ2xpY2siLCJldmVudCIsInN0b3BQcm9wYWdhdGlvbiIsInByZXZlbnREZWZhdWx0Iiwib25LZXlEb3duIiwia2V5Q29kZSIsImNvbXBvbmVudERpZE1vdW50Iiwid2luZG93IiwiYWRkRXZlbnRMaXN0ZW5lciIsImNvbXBvbmVudFdpbGxVbm1vdW50IiwicmVtb3ZlRXZlbnRMaXN0ZW5lciIsInJlbmRlciIsInN0eWxlIiwicG9zaXRpb24iLCJ0b3AiLCJyaWdodCIsIndpZHRoIiwiaGVpZ2h0IiwiY2xvbmVFbGVtZW50IiwibW9kdWxlIiwiZXhwb3J0cyJdLCJtYXBwaW5ncyI6Ijs7QUFBQSxJQUFNQSxRQUFRQyxRQUFRLE9BQVIsQ0FBZDs7QUFFQTs7Ozs7Ozs7OztBQVVBLElBQU1DLFdBQVdGLE1BQU1HLFdBQU4sQ0FBa0I7QUFBQTs7QUFDL0JDLGVBQVc7QUFDUDtBQUNBQyxnQkFBVUwsTUFBTU0sU0FBTixDQUFnQkMsSUFGbkI7QUFHUDtBQUNBQyxnQkFBVVIsTUFBTU0sU0FBTixDQUFnQkcsTUFKbkI7QUFLUDtBQUNBQyxpQkFBVVYsTUFBTU0sU0FBTixDQUFnQkssSUFBaEIsQ0FBcUJDLFVBTnhCO0FBT1BDLGtCQUFVYixNQUFNTSxTQUFOLENBQWdCUSxJQUFoQixDQUFxQkYsVUFQeEI7QUFRUEcsaUJBQVVmLE1BQU1NLFNBQU4sQ0FBZ0JRO0FBUm5CLEtBRG9COztBQVkvQkUsbUJBWitCLDZCQVliO0FBQ2QsZUFBTztBQUNIWCxvQkFBUSxJQURMO0FBRUhHLG9CQUFRLEdBRkw7QUFHSE8scUJBQVM7QUFITixTQUFQO0FBS0gsS0FsQjhCO0FBb0IvQkwsV0FwQitCLHFCQW9CckI7QUFBQSxZQUNFQSxPQURGLEdBQ2MsS0FBS08sS0FEbkIsQ0FDRVAsT0FERjs7QUFFTkE7QUFDSCxLQXZCOEI7QUF5Qi9CUSxXQXpCK0IsbUJBeUJ2QkMsS0F6QnVCLEVBeUJoQjtBQUNYQSxjQUFNQyxlQUFOO0FBQ0FELGNBQU1FLGNBQU47QUFDQSxhQUFLWCxPQUFMO0FBQ0gsS0E3QjhCO0FBK0IvQlksYUEvQitCLHFCQStCckJILEtBL0JxQixFQStCZDtBQUFBLFlBQ0xkLE1BREssR0FDTSxLQUFLWSxLQURYLENBQ0xaLE1BREs7OztBQUdiLFlBQUljLE1BQU1JLE9BQU4sS0FBa0IsRUFBbEIsSUFBd0JsQixNQUE1QixFQUFvQztBQUNoQyxpQkFBS0ssT0FBTDtBQUNIO0FBQ0osS0FyQzhCO0FBdUMvQmMscUJBdkMrQiwrQkF1Q1g7QUFDaEJDLGVBQU9DLGdCQUFQLENBQXdCLFNBQXhCLEVBQW1DLEtBQUtKLFNBQXhDO0FBQ0gsS0F6QzhCO0FBMkMvQkssd0JBM0MrQixrQ0EyQ1I7QUFDbkJGLGVBQU9HLG1CQUFQLENBQTJCLFNBQTNCLEVBQXNDLEtBQUtOLFNBQTNDO0FBQ0gsS0E3QzhCO0FBK0MvQk8sVUEvQytCLG9CQStDdEI7QUFBQSxxQkFDaUMsS0FBS1osS0FEdEM7QUFBQSxZQUNHVCxNQURILFVBQ0dBLE1BREg7QUFBQSxZQUNXTyxPQURYLFVBQ1dBLE9BRFg7QUFBQSxZQUNvQkYsUUFEcEIsVUFDb0JBLFFBRHBCOztBQUVMLFlBQU1pQixRQUFRO0FBQ1Z0QiwwQkFEVTtBQUVWdUIsc0JBQVUsT0FGQTtBQUdWQyxpQkFBSyxDQUhLO0FBSVZDLG1CQUFPLENBSkc7QUFLVkMsbUJBQU8sTUFMRztBQU1WQyxvQkFBUTtBQU5FLFNBQWQ7O0FBU0EsZUFBT25DLE1BQU1vQyxZQUFOLENBQW1CckIsT0FBbkIsRUFBNEIsRUFBNUIsRUFDSCw2QkFBSyxPQUFPZSxLQUFaLEVBQW1CLFNBQVMsS0FBS1osT0FBakMsR0FERyxFQUVISCxRQUFRRSxLQUFSLENBQWNKLFFBRlgsRUFHSEEsUUFIRyxDQUFQO0FBS0g7QUEvRDhCLENBQWxCLENBQWpCOztBQWtFQXdCLE9BQU9DLE9BQVAsR0FBaUJwQyxRQUFqQiIsImZpbGUiOiJCYWNrZHJvcC5qcyIsInNvdXJjZXNDb250ZW50IjpbImNvbnN0IFJlYWN0ID0gcmVxdWlyZSgncmVhY3QnKTtcblxuLyoqXG4gKiBCYWNrZHJvcCBmb3IgbW9kYWxzLCBkcm9wZG93biwgcG9wb3Zlci5cbiAqXG4gKlxuICogRm9yIGV4YW1wbGU6XG4gKlxuICogPEJhY2tkcm9wIG9uQ2xvc2U9e29uQ2xvc2VQb3BvdmVyfT5cbiAqICAgICAgPFBvcG92ZXI+Li4uPC9Qb3BvdmVyPlxuICogPC9CYWNrZHJvcD5cbiAqL1xuY29uc3QgQmFja2Ryb3AgPSBSZWFjdC5jcmVhdGVDbGFzcyh7XG4gICAgcHJvcFR5cGVzOiB7XG4gICAgICAgIC8vIENsb3NlIG9uIGVzY2FwZVxuICAgICAgICBlc2NhcGU6ICAgUmVhY3QuUHJvcFR5cGVzLmJvb2wsXG4gICAgICAgIC8vIFotaW5kZXggZm9yIHRoZSBiYWNrZHJvcFxuICAgICAgICB6SW5kZXg6ICAgUmVhY3QuUHJvcFR5cGVzLm51bWJlcixcbiAgICAgICAgLy8gQ2FsbGJhY2sgd2hlbiBiYWNrZHJvcCBpcyBjbG9zZWRcbiAgICAgICAgb25DbG9zZTogIFJlYWN0LlByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG4gICAgICAgIGNoaWxkcmVuOiBSZWFjdC5Qcm9wVHlwZXMubm9kZS5pc1JlcXVpcmVkLFxuICAgICAgICB3cmFwcGVyOiAgUmVhY3QuUHJvcFR5cGVzLm5vZGVcbiAgICB9LFxuXG4gICAgZ2V0RGVmYXVsdFByb3BzKCkge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgZXNjYXBlOiB0cnVlLFxuICAgICAgICAgICAgekluZGV4OiAyMDAsXG4gICAgICAgICAgICB3cmFwcGVyOiA8ZGl2IC8+XG4gICAgICAgIH07XG4gICAgfSxcblxuICAgIG9uQ2xvc2UoKSB7XG4gICAgICAgIGNvbnN0IHsgb25DbG9zZSB9ID0gdGhpcy5wcm9wcztcbiAgICAgICAgb25DbG9zZSgpO1xuICAgIH0sXG5cbiAgICBvbkNsaWNrKGV2ZW50KSB7XG4gICAgICAgIGV2ZW50LnN0b3BQcm9wYWdhdGlvbigpO1xuICAgICAgICBldmVudC5wcmV2ZW50RGVmYXVsdCgpO1xuICAgICAgICB0aGlzLm9uQ2xvc2UoKTtcbiAgICB9LFxuXG4gICAgb25LZXlEb3duKGV2ZW50KSB7XG4gICAgICAgIGNvbnN0IHsgZXNjYXBlIH0gPSB0aGlzLnByb3BzO1xuXG4gICAgICAgIGlmIChldmVudC5rZXlDb2RlID09PSAyNyAmJiBlc2NhcGUpIHtcbiAgICAgICAgICAgIHRoaXMub25DbG9zZSgpO1xuICAgICAgICB9XG4gICAgfSxcblxuICAgIGNvbXBvbmVudERpZE1vdW50KCkge1xuICAgICAgICB3aW5kb3cuYWRkRXZlbnRMaXN0ZW5lcigna2V5ZG93bicsIHRoaXMub25LZXlEb3duKTtcbiAgICB9LFxuXG4gICAgY29tcG9uZW50V2lsbFVubW91bnQoKSB7XG4gICAgICAgIHdpbmRvdy5yZW1vdmVFdmVudExpc3RlbmVyKCdrZXlkb3duJywgdGhpcy5vbktleURvd24pO1xuICAgIH0sXG5cbiAgICByZW5kZXIoKSB7XG4gICAgICAgIGNvbnN0IHsgekluZGV4LCB3cmFwcGVyLCBjaGlsZHJlbiB9ID0gdGhpcy5wcm9wcztcbiAgICAgICAgY29uc3Qgc3R5bGUgPSB7XG4gICAgICAgICAgICB6SW5kZXgsXG4gICAgICAgICAgICBwb3NpdGlvbjogJ2ZpeGVkJyxcbiAgICAgICAgICAgIHRvcDogMCxcbiAgICAgICAgICAgIHJpZ2h0OiAwLFxuICAgICAgICAgICAgd2lkdGg6ICcxMDAlJyxcbiAgICAgICAgICAgIGhlaWdodDogJzEwMCUnXG4gICAgICAgIH07XG5cbiAgICAgICAgcmV0dXJuIFJlYWN0LmNsb25lRWxlbWVudCh3cmFwcGVyLCB7fSxcbiAgICAgICAgICAgIDxkaXYgc3R5bGU9e3N0eWxlfSBvbkNsaWNrPXt0aGlzLm9uQ2xpY2t9PjwvZGl2PixcbiAgICAgICAgICAgIHdyYXBwZXIucHJvcHMuY2hpbGRyZW4sXG4gICAgICAgICAgICBjaGlsZHJlblxuICAgICAgICApO1xuICAgIH1cbn0pO1xuXG5tb2R1bGUuZXhwb3J0cyA9IEJhY2tkcm9wO1xuIl19