'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var React = require('react');
var classNames = require('classnames');

var SIZES = require('./SIZES');

var Input = React.createClass({
    displayName: 'Input',

    propTypes: {
        className: React.PropTypes.string,
        onChange: React.PropTypes.func,
        onFocus: React.PropTypes.func,
        onBlur: React.PropTypes.func,
        onPaste: React.PropTypes.func,
        onKeyDown: React.PropTypes.func,
        onClick: React.PropTypes.func,
        name: React.PropTypes.string,
        type: React.PropTypes.string,
        placeholder: React.PropTypes.string,
        disabled: React.PropTypes.bool,
        focus: React.PropTypes.bool,
        readOnly: React.PropTypes.bool,
        autoFocus: React.PropTypes.bool,
        size: React.PropTypes.oneOf(SIZES),
        defaultValue: React.PropTypes.string,
        value: React.PropTypes.oneOfType([React.PropTypes.string, React.PropTypes.bool])
    },

    /*
        APIs for parent component
     */
    focus: function focus() {
        this.refs.input.focus();
    },
    blur: function blur() {
        this.refs.input.blur();
    },
    getDefaultProps: function getDefaultProps() {
        return {
            type: 'text',
            size: SIZES[0]
        };
    },
    onChange: function onChange(e) {
        if (this.props.onChange) {
            this.props.onChange(e);
        }
    },
    render: function render() {
        var _props = this.props,
            onPaste = _props.onPaste,
            onBlur = _props.onBlur,
            onFocus = _props.onFocus,
            onKeyDown = _props.onKeyDown,
            onClick = _props.onClick,
            value = _props.value,
            readOnly = _props.readOnly,
            defaultValue = _props.defaultValue,
            size = _props.size,
            autoFocus = _props.autoFocus,
            placeholder = _props.placeholder,
            type = _props.type,
            focus = _props.focus,
            name = _props.name,
            disabled = _props.disabled;


        var className = classNames('form-control', 'input-' + size, this.props.className, {
            focus: focus
        });

        return React.createElement('input', {
            ref: 'input',
            type: type,
            autoFocus: autoFocus,
            className: className,
            disabled: disabled,
            readOnly: readOnly,
            name: name,
            value: value,
            defaultValue: defaultValue,
            placeholder: placeholder,
            onFocus: onFocus,
            onBlur: onBlur,
            onKeyDown: onKeyDown,
            onClick: onClick,
            onPaste: onPaste,
            onChange: this.onChange
        });
    }
});

/**
 * Create a style of alert
 * @param {String} style
 * @return {React.Component}
 */
function createInputType(type) {
    return React.createClass({
        displayName: Input.displayName + type,
        render: function render() {
            return React.createElement(Input, _extends({}, this.props, { type: type.toLowerCase() }));
        }
    });
}

var InputGroup = React.createClass({
    displayName: 'InputGroup',

    propTypes: {
        children: React.PropTypes.node,
        className: React.PropTypes.string
    },

    render: function render() {
        var className = classNames('input-group', this.props.className || []);
        return React.createElement(
            'div',
            { className: className },
            this.props.children
        );
    }
});

var InputGroupAddon = React.createClass({
    displayName: 'InputGroupAddon',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'span',
            _extends({}, this.props, { className: 'input-group-addon' }),
            this.props.children
        );
    }
});

module.exports = Input;
module.exports.Email = createInputType('Email');
module.exports.Password = createInputType('Password');
module.exports.Group = InputGroup;
module.exports.GroupAddon = InputGroupAddon;
//# sourceMappingURL=data:application/json;base64,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