'use strict';

var React = require('react');
var bool = React.PropTypes.bool;

/**
 * Displays a progress bar (YouTube-like) at the top of container
 * Based on https://github.com/lonelyclick/react-loading-bar/blob/master/src/Loading.jsx
 */

var ProgressBar = React.createClass({
    displayName: 'ProgressBar',

    propTypes: {
        show: bool
    },

    getDefaultProps: function getDefaultProps() {
        return {
            show: false
        };
    },
    getInitialState: function getInitialState() {
        return {
            size: 0,
            disappearDelayHide: false, // when dispappear, first transition then display none
            percent: 0,
            appearDelayWidth: 0 // when appear, first display block then transition width
        };
    },
    componentWillReceiveProps: function componentWillReceiveProps(nextProps) {
        var show = nextProps.show;


        if (show) {
            this.show();
        } else {
            this.hide();
        }
    },
    shouldComponentUpdate: function shouldComponentUpdate(nextProps, nextState) {
        return true; // !shallowEqual(nextState, this.state)
    },
    show: function show() {
        var _this = this;

        var _state = this.state,
            size = _state.size,
            percent = _state.percent;


        var appearDelayWidth = size === 0;
        percent = calculatePercent(percent);

        this.setState({
            size: ++size,
            appearDelayWidth: appearDelayWidth,
            percent: percent
        });

        if (appearDelayWidth) {
            setTimeout(function () {
                _this.setState({
                    appearDelayWidth: false
                });
            });
        }
    },
    hide: function hide() {
        var _this2 = this;

        var size = this.state.size;


        if (--size < 0) {
            this.setState({ size: 0 });
            return;
        }

        this.setState({
            size: 0,
            disappearDelayHide: true,
            percent: 1
        });

        setTimeout(function () {
            _this2.setState({
                disappearDelayHide: false,
                percent: 0
            });
        }, 500);
    },
    getBarStyle: function getBarStyle() {
        var _state2 = this.state,
            disappearDelayHide = _state2.disappearDelayHide,
            appearDelayWidth = _state2.appearDelayWidth,
            percent = _state2.percent;


        return {
            width: appearDelayWidth ? 0 : percent * 100 + '%',
            display: disappearDelayHide || percent > 0 ? 'block' : 'none'
        };
    },
    getShadowStyle: function getShadowStyle() {
        var _state3 = this.state,
            percent = _state3.percent,
            disappearDelayHide = _state3.disappearDelayHide;


        return {
            display: disappearDelayHide || percent > 0 ? 'block' : 'none'
        };
    },
    render: function render() {
        return React.createElement(
            'div',
            { className: 'progress-bar' },
            React.createElement(
                'div',
                { className: 'bar', style: this.getBarStyle() },
                React.createElement('div', { className: 'progress-bar-shadow',
                    style: this.getShadowStyle() })
            )
        );
    }
});

function calculatePercent(percent) {
    percent = percent || 0;

    // How much of remaining bar we advance
    var progress = 0.1 + Math.random() * 0.3;

    return percent + progress * (1 - percent);
}

module.exports = ProgressBar;
//# sourceMappingURL=data:application/json;base64,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