'use strict';

var React = require('react');
var classNames = require('classnames');

var POSITIONS = {
    BOTTOM_RIGHT: 'e',
    BOTTOM_LEFT: 'w',
    TOP_LEFT: 'nw',
    TOP_RIGHT: 'ne',
    BOTTOM: '',
    TOP: 'n'
};

var Tooltip = React.createClass({
    displayName: 'Tooltip',

    propTypes: {
        title: React.PropTypes.string.isRequired,
        position: React.PropTypes.string,
        open: React.PropTypes.bool,
        children: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            open: false,
            position: POSITIONS.BOTTOM
        };
    },
    render: function render() {
        var className = classNames('tooltipped-overlay', 'tooltipped-' + this.props.position, 'tooltipped', {
            'tooltipped-o': this.props.open
        });

        return React.createElement(
            'div',
            { className: className, 'aria-label': this.props.title },
            this.props.children
        );
    }
});

module.exports = Tooltip;
module.exports.POSITIONS = POSITIONS;
//# sourceMappingURL=data:application/json;base64,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