'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('react');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Blankslate = require('../src/Blankslate');

var SCOPE = { React: React, Blankslate: Blankslate };

var EXAMPLE_DEFAULT = '<Blankslate icon="book">\n    <h3>No books</h3>\n    <p>Create a book to get started</p>\n</Blankslate>';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Blankslates', active: 'blankslates' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Blankslate' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(
                    'p',
                    null,
                    'Blankslates are for when there is a lack of content within a page or section.',
                    ' ',
                    'Use them as placeholders to tell users why something isn\u2019t there. Be sure to provide an action to add content as well.'
                ),
                React.createElement(CodeEditor, { source: 'const Blankslate = require(\'gitbook-styleguide/lib/Blankslate\');' })
            )
        ),
        React.createElement(Example, { title: 'Default', source: EXAMPLE_DEFAULT, scope: SCOPE })
    );
};
//# sourceMappingURL=data:application/json;base64,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