'use strict';

var React = require('/Users/jpreynat/Gitbook/styleguide/node_modules/react/react.js');
var classNames = require('classnames');

var SIZES = require('./SIZES');

/**
 * An icon using an internal SVG.
 *
 * @type {ReactClass}
 */
var SVGIcon = React.createClass({
    displayName: 'SVGIcon',

    propTypes: {
        svg: React.PropTypes.string,
        className: React.PropTypes.string,
        size: React.PropTypes.oneOf(SIZES)
    },

    getDefaultProps: function getDefaultProps() {
        return {
            size: 'sm'
        };
    },
    render: function render() {
        var _props = this.props,
            svg = _props.svg,
            size = _props.size,
            className = _props.className;

        var cl = classNames('Icon', 'SVGIcon', 'size-' + size, className);

        return React.createElement('span', { className: cl, dangerouslySetInnerHTML: { __html: svg } });
    }
});

module.exports = SVGIcon;