'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('/Users/jpreynat/Gitbook/styleguide/node_modules/react/react.js');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Alert = require('../src/Alert');
var Icon = require('../src/Icon');

var SCOPE = { React: React, Alert: Alert, Icon: Icon };

var EXAMPLE_DEFAULT = '<Alert.Info>Flash message goes here.</Alert.Info>';
var EXAMPLE_DANGER = '<Alert.Danger>\n    <Icon id="alert" size="sm" /> This is an alert!\n</Alert.Danger>';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Alerts', active: 'alerts' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Alerts' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(
                    'p',
                    null,
                    'Flash messages, or alerts, inform users of successful or pending actions. Use them sparingly. Don\u2019t show more than one at a time.'
                ),
                React.createElement(CodeEditor, { source: 'const Alert = require(\'gitbook-styleguide/lib/Alert\');' })
            )
        ),
        React.createElement(Example, { title: 'Default', source: EXAMPLE_DEFAULT, scope: SCOPE }),
        React.createElement(Example, { title: 'Danger', source: EXAMPLE_DANGER, scope: SCOPE })
    );
};
    if (module.hot) {
      module.hot.accept()

      var Component = module.exports.default || module.exports
      Component.__route = "/alerts"

      if (module.hot.status() !== 'idle') {
        var components = next.router.components
        for (var r in components) {
          if (!components.hasOwnProperty(r)) continue

          if (components[r].Component.__route === "/alerts") {
            next.router.update(r, Component)
          }
        }
      }
    }
  