'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('/Users/jpreynat/Gitbook/styleguide/node_modules/react/react.js');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Card = require('../src/Card');
var Row = require('../src/Row');
var Button = require('../src/Button');
var Icon = require('../src/Icon');

var SCOPE = { React: React, Card: Card, Row: Row, Button: Button, Icon: Icon };

var EXAMPLE_IMPORT = 'const Card = require(\'gitbook-styleguide/lib/Card\')';
var EXAMPLE_DEFAULT = '<Row>\n    <Row.Col md={6}>\n        <Card>\n            <Card.Heading title="Official Documentation" />\n            <Card.Body>\n                <p>\n                    <Card.Flag><Icon id="zap" /></Card.Flag>{\' \'}\n                    Learn about our awesome API. Manage users, books, discussions, display content are just a few of the things you can do with it.{\' \'}\n                    Learn about our awesome API. Manage users, books, discussions, display content are just a few of the things you can do with it.\n                </p>\n                <p>Created 2 months ago</p>\n            </Card.Body>\n            <Card.Actions>\n                <Button>Read</Button>\n                <Button>Edit</Button>\n            </Card.Actions>\n        </Card>\n    </Row.Col>\n</Row>';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Cards', active: 'cards' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Cards' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(
                    'p',
                    null,
                    'Cards are container for informations in a list (like books, users, plugins). Each cards has a title, body and a set of actions.'
                ),
                React.createElement(
                    'p',
                    null,
                    'Cards are design for quick access with optional secondary actions.'
                ),
                React.createElement(CodeEditor, { source: EXAMPLE_IMPORT })
            )
        ),
        React.createElement(Example, { title: 'Default', source: EXAMPLE_DEFAULT, scope: SCOPE })
    );
};
    if (module.hot) {
      module.hot.accept()

      var Component = module.exports.default || module.exports
      Component.__route = "/cards"

      if (module.hot.status() !== 'idle') {
        var components = next.router.components
        for (var r in components) {
          if (!components.hasOwnProperty(r)) continue

          if (components[r].Component.__route === "/cards") {
            next.router.update(r, Component)
          }
        }
      }
    }
  