'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('/Users/jpreynat/Gitbook/styleguide/node_modules/react/react.js');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Form = require('../src/Form');
var Icon = require('../src/Icon');
var Input = require('../src/Input');
var Button = require('../src/Button');
var Select = require('../src/Select');
var Checkbox = require('../src/Checkbox');
var Textarea = require('../src/Textarea');

var SCOPE = { React: React, Form: Form, Input: Input, Icon: Icon, Button: Button, Select: Select, Checkbox: Checkbox, Textarea: Textarea };

var EXAMPLE_IMPORT = 'const Form = require(\'gitbook-styleguide/lib/Form\');\nconst Input = require(\'gitbook-styleguide/lib/Input\');';

var EXAMPLE_DEFAULT = '<Form>\n    <Form.Group>\n        <label>Name</label>\n        <Input name="name" placeholder="John" />\n    </Form.Group>\n    <Form.Group>\n        <label>Email address</label>\n        <Input name="email" placeholder="john@doe.com" />\n    </Form.Group>\n    <Form.Group>\n        <label>Message</label>\n        <Textarea placeholder="Some message" />\n    </Form.Group>\n    <Form.Actions>\n        <Button type="submit" style="primary">Submit</Button>\n        <Button type="cancel" style="secondary">Cancel</Button>\n    </Form.Actions>\n</Form>';

var EXAMPLE_SIZES = '<Input size="lg" placeholder="Large input" />\n<Input size="md" placeholder="Normal input" />\n<Input size="sm" placeholder="Small input" />\n<Input size="xs" placeholder="Extra small input" />';

var EXAMPLE_SELECT = '<Select\n    name="language"\n    search={false}\n    options={[\n        \'French\',\n        \'English\'\n    ]}\n/>';

var EXAMPLE_STATES = '<Form>\n    <Form.Group error>\n        <label>Name</label>\n        <Input name="name" placeholder="This field has an error" />\n    </Form.Group>\n    <Form.Group>\n        <label>Email address</label>\n        <Input name="email" disabled placeholder="This field is disabled" />\n    </Form.Group>\n    <Form.Group>\n        <label>Email address</label>\n        <Input name="email" focus placeholder="This field is focus" />\n    </Form.Group>\n    <Form.Group>\n        <label>Email address</label>\n        <Input name="email" readOnly placeholder="This field is read only" />\n    </Form.Group>\n</Form>';

var EXAMPLE_CHECKBOX = '<Form>\n    <Checkbox name="something" checked>\n        Something to check (with control state)\n    </Checkbox>\n    <Checkbox name="something" size="lg">\n        Something to check (Large)\n    </Checkbox>\n    <Checkbox name="something" direction="right">\n        Something to check (On the right)\n    </Checkbox>\n</Form>';

var EXAMPLE_INPUTGROUP = '<Form>\n    <Form.Group>\n        <label>Email address</label>\n        <Input.Group>\n            <Input.GroupAddon>\n                @\n            </Input.GroupAddon>\n            <Input name="email" placeholder="Enter an email" />\n        </Input.Group>\n    </Form.Group>\n</Form>';

var EXAMPLE_SELECT_COMPLEX = '<Select\n    name="countries"\n    filter={(query, option) => option.label.indexOf(query) >= 0}\n    component={({option}) => <span>{option.label}</span>}\n    options={[\n        { id: \'US\', label: \'United States\' },\n        { id: \'FR\', label: \'France\' },\n        { id: \'UK\', label: \'United Kingdom\' }\n    ]}\n/>';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Forms and Inputs', active: 'forms' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Forms and Inputs' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(
                    'p',
                    null,
                    'These components are the basic building blocks for creating forms.',
                    ' ',
                    'Each of these elements can be used individually throughout the site,',
                    ' ',
                    'however it\'s recommended to use the field components when building forms',
                    ' ',
                    'in order to take advantage of their accessibility and responsive features.'
                ),
                React.createElement(CodeEditor, { source: EXAMPLE_IMPORT })
            )
        ),
        React.createElement(Example, { title: 'Layout', source: EXAMPLE_DEFAULT, scope: SCOPE }),
        React.createElement(
            Example,
            { title: 'Sizing', source: EXAMPLE_SIZES, scope: SCOPE },
            'Make inputs smaller, larger, or full-width with an additional property.'
        ),
        React.createElement(
            Example,
            { title: 'States', source: EXAMPLE_STATES, scope: SCOPE },
            'States can be used to signal an error on a field.'
        ),
        React.createElement(Example, { title: 'Checkbox', source: EXAMPLE_CHECKBOX, scope: SCOPE }),
        React.createElement(
            Example,
            { title: 'Input Groups', source: EXAMPLE_INPUTGROUP, scope: SCOPE },
            'Extend form controls by adding text or buttons before, after, or on both sides of any text-based input.'
        ),
        React.createElement(
            Example,
            { title: 'Select', source: EXAMPLE_SELECT, scope: SCOPE },
            'HTML select are replaced by an input allowing more options (search, multiple values, custom renderers with icons, etc).'
        ),
        React.createElement(
            Example,
            { title: 'Complex Select', source: EXAMPLE_SELECT_COMPLEX, scope: SCOPE },
            React.createElement(
                'code',
                null,
                'Select'
            ),
            ' has different properties for customizing the rendering and the behaviour.'
        )
    );
};
    if (module.hot) {
      module.hot.accept()

      var Component = module.exports.default || module.exports
      Component.__route = "/forms"

      if (module.hot.status() !== 'idle') {
        var components = next.router.components
        for (var r in components) {
          if (!components.hasOwnProperty(r)) continue

          if (components[r].Component.__route === "/forms") {
            next.router.update(r, Component)
          }
        }
      }
    }
  