'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('/Users/jpreynat/Gitbook/styleguide/node_modules/react/react.js');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Tooltip = require('../src/Tooltip');
var Button = require('../src/Button');

var SCOPE = { React: React, Tooltip: Tooltip, Button: Button };

var EXAMPLE_IMPORT = 'const Tooltip = require(\'gitbook-styleguide/lib/Tooltip\');';

var EXAMPLE_DEFAULT = '<Tooltip title="Hello World">\n     There is a tooltip\n</Tooltip>\n<Tooltip title="Hello World">\n     , hover this text.\n</Tooltip>\n<Tooltip title="Hello World" open>\n     This one is open\n</Tooltip>';

var EXAMPLE_POSITIONS = '<Tooltip title="Bottom right" open position={Tooltip.POSITIONS.BOTTOM_RIGHT}>\n    <code>Bottom right</code>\n</Tooltip>\n<Tooltip title="Top right" open position={Tooltip.POSITIONS.TOP_RIGHT}>\n    <code>Top right</code>\n</Tooltip>\n<Tooltip title="Bottom" open position={Tooltip.POSITIONS.BOTTOM}>\n    <code>Bottom</code>\n</Tooltip>\n<Tooltip title="Bottom left" open position={Tooltip.POSITIONS.BOTTOM_LEFT}>\n    <code>Bottom left</code>\n</Tooltip>\n<Tooltip title="Top" open position={Tooltip.POSITIONS.TOP}>\n    <code>Top</code>\n</Tooltip>';

var EXAMPLE_BUTTONS = '<Button.Toolbar>\n    <Button title="Hello 1">Do something</Button>\n    <Button title="Hello 2">Else</Button>\n</Button.Toolbar>';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Tooltips', active: 'tooltips' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Tooltips' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(CodeEditor, { source: EXAMPLE_IMPORT })
            )
        ),
        React.createElement(Example, { title: 'Example', source: EXAMPLE_DEFAULT, scope: SCOPE }),
        React.createElement(Example, { title: 'Positions', source: EXAMPLE_POSITIONS, scope: SCOPE }),
        React.createElement(Example, { title: 'Buttons', source: EXAMPLE_BUTTONS, scope: SCOPE })
    );
};
    if (module.hot) {
      module.hot.accept()

      var Component = module.exports.default || module.exports
      Component.__route = "/tooltips"

      if (module.hot.status() !== 'idle') {
        var components = next.router.components
        for (var r in components) {
          if (!components.hasOwnProperty(r)) continue

          if (components[r].Component.__route === "/tooltips") {
            next.router.update(r, Component)
          }
        }
      }
    }
  