'use strict';

var React = require('/Users/jpreynat/Gitbook/styleguide/node_modules/react/react.js');
var classNames = require('classnames');

var Icon = require('./Icon');

/**
 * Blankslate represent an emptycontent
 *
 * <Blankslate icon="book">
 *      <h3>No books</h3>
 *      <p>Create a book to get started</p>
 * </Blankslate>
 */

var Blankslate = React.createClass({
    displayName: 'Blankslate',

    propTypes: {
        icon: React.PropTypes.string,
        background: React.PropTypes.bool,
        full: React.PropTypes.bool,
        children: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            background: false,
            full: true
        };
    },
    render: function render() {
        var inner = void 0;
        var icon = this.props.icon;
        var className = classNames('blankslate', {
            'with-background': this.props.background,
            'full-width': this.props.full
        });

        if (icon) {
            inner = React.createElement(
                BlankslateIcon,
                null,
                React.createElement(Icon, { id: icon })
            );
        }

        return React.createElement(
            'div',
            { className: className },
            inner,
            this.props.children
        );
    }
});

var BlankslateIcon = React.createClass({
    displayName: 'BlankslateIcon',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'icon' },
            this.props.children
        );
    }
});

/*
 * A full space layout with a blanksate
 */
var BlankslateLayout = React.createClass({
    displayName: 'BlankslateLayout',

    propTypes: {
        background: React.PropTypes.bool,
        children: React.PropTypes.node
    },

    render: function render() {
        var _props = this.props,
            children = _props.children,
            background = _props.background;

        var className = classNames('blankslate-layout', {
            'with-background': background
        });

        return React.createElement(
            'div',
            { className: className },
            children
        );
    }
});

module.exports = Blankslate;
module.exports.Layout = BlankslateLayout;
module.exports.Icon = BlankslateIcon;