'use strict';

var _extends2 = require('/Users/jpreynat/Gitbook/styleguide/node_modules/next/node_modules/babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

var _objectWithoutProperties2 = require('/Users/jpreynat/Gitbook/styleguide/node_modules/next/node_modules/babel-runtime/helpers/objectWithoutProperties');

var _objectWithoutProperties3 = _interopRequireDefault(_objectWithoutProperties2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var React = require('/Users/jpreynat/Gitbook/styleguide/node_modules/react/react.js');
var classNames = require('classnames');

/**
 * Title (text) of the card
 * @type {ReactClass}
 */
var CardTitle = React.createClass({
    displayName: 'CardTitle',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        var children = this.props.children;


        return React.createElement(
            'h3',
            { className: 'CardTitle' },
            children
        );
    }
});

/**
 * Small icon to indicate a type/flag on the card.
 * @type {ReactClass}
 */
var CardFlag = React.createClass({
    displayName: 'CardFlag',

    propTypes: {
        children: React.PropTypes.node,
        style: React.PropTypes.string
    },

    render: function render() {
        var _props = this.props,
            children = _props.children,
            style = _props.style;

        var className = classNames('CardFlag', 'style-' + style);

        return React.createElement(
            'span',
            { className: className },
            children
        );
    }
});

/**
 * Container for the title of the card.
 * @type {ReactClass}
 */
var CardHeading = React.createClass({
    displayName: 'CardHeading',

    propTypes: {
        children: React.PropTypes.node,
        title: React.PropTypes.string
    },

    render: function render() {
        var _props2 = this.props,
            children = _props2.children,
            title = _props2.title;


        if (title) {
            children = React.createElement(
                CardTitle,
                null,
                title
            );
        }

        return React.createElement(
            'div',
            { className: 'CardHeading' },
            children
        );
    }
});

/**
 * Container for the inner text and description of the card.
 * @type {ReactClass}
 */
var CardBody = React.createClass({
    displayName: 'CardBody',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        var children = this.props.children;


        return React.createElement(
            'div',
            { className: 'CardBody' },
            children
        );
    }
});

/**
 * Container for the actions of the card.
 * It prevent the propagation of clicks to the card itself.
 *
 * @type {ReactClass}
 */
var CardActions = React.createClass({
    displayName: 'CardActions',

    propTypes: {
        children: React.PropTypes.node
    },

    onClick: function onClick(event) {
        event.stopPropagation();
    },
    render: function render() {
        var children = this.props.children;


        return React.createElement(
            'div',
            { className: 'CardActions', onClick: this.onClick },
            children
        );
    }
});

/**
 * Container for the card.
 * @type {ReactClass}
 */
var Card = React.createClass({
    displayName: 'Card',

    propTypes: {
        children: React.PropTypes.node,
        href: React.PropTypes.string,
        onClick: React.PropTypes.func
    },
    statics: {
        Body: CardBody,
        Heading: CardHeading,
        Title: CardTitle,
        Actions: CardActions,
        Flag: CardFlag
    },

    onClick: function onClick(event) {
        var _props3 = this.props,
            onClick = _props3.onClick,
            href = _props3.href;


        if (href) {
            event.stopPropagation();
            event.preventDefault();

            window.location.href = href;
        } else {
            onClick(event);
        }
    },
    render: function render() {
        var _props4 = this.props,
            children = _props4.children,
            onClick = _props4.onClick,
            href = _props4.href,
            props = (0, _objectWithoutProperties3.default)(_props4, ['children', 'onClick', 'href']); // eslint-disable-line no-unused-vars

        return React.createElement(
            'div',
            (0, _extends3.default)({}, props, { className: 'Card', onClick: this.onClick }),
            children
        );
    }
});

module.exports = Card;