'use strict';

var _extends2 = require('/Users/jpreynat/Gitbook/styleguide/node_modules/next/node_modules/babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

var _objectWithoutProperties2 = require('/Users/jpreynat/Gitbook/styleguide/node_modules/next/node_modules/babel-runtime/helpers/objectWithoutProperties');

var _objectWithoutProperties3 = _interopRequireDefault(_objectWithoutProperties2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var React = require('/Users/jpreynat/Gitbook/styleguide/node_modules/react/react.js');
var classNames = require('classnames');

var SIZES = require('./SIZES');
var DIRECTIONS = ['left', 'right'];

var Checkbox = React.createClass({
    displayName: 'Checkbox',


    propTypes: {
        children: React.PropTypes.node,
        checked: React.PropTypes.bool,
        defaultChecked: React.PropTypes.bool,
        onChange: React.PropTypes.func,
        name: React.PropTypes.string,
        disabled: React.PropTypes.bool,
        displaySwitch: React.PropTypes.bool,
        size: React.PropTypes.oneOf(SIZES),
        direction: React.PropTypes.oneOf(DIRECTIONS)
    },

    getDefaultProps: function getDefaultProps() {
        return {
            displaySwitch: true,
            size: SIZES[0],
            direction: DIRECTIONS[0]
        };
    },
    onSwitchClick: function onSwitchClick(event) {
        event.stopPropagation();
        this.refs.checkbox.click();
    },
    render: function render() {
        var _props = this.props,
            size = _props.size,
            displaySwitch = _props.displaySwitch,
            direction = _props.direction,
            children = _props.children,
            props = (0, _objectWithoutProperties3.default)(_props, ['size', 'displaySwitch', 'direction', 'children']);


        var className = classNames('checkbox', 'switch-' + size, 'switch-' + direction, {
            'checkbox-switch': displaySwitch
        });

        return React.createElement(
            'div',
            { className: className },
            React.createElement(
                'label',
                { htmlFor: this.props.name },
                React.createElement('input', (0, _extends3.default)({
                    ref: 'checkbox',
                    type: 'checkbox'
                }, props)),
                displaySwitch ? React.createElement('span', { onClick: this.onSwitchClick }) : null,
                React.createElement(
                    'div',
                    { className: 'checkbox-inline-label', onClick: this.onSwitchClick },
                    children
                )
            )
        );
    }
});

module.exports = Checkbox;