'use strict';

var React = require('/Users/jpreynat/Gitbook/styleguide/node_modules/react/react.js');
var classNames = require('classnames');
var Icon = require('./Icon');

/**
 * Component to create overviews/intros with a title, description,
 * metas info (links), and a picture.
 */
var Overview = React.createClass({
    displayName: 'Overview',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'overview' },
            this.props.children
        );
    }
});

Overview.Title = React.createClass({
    displayName: 'Title',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'h1',
            { className: 'overview-title' },
            this.props.children
        );
    }
});

Overview.StepTitle = React.createClass({
    displayName: 'StepTitle',

    propTypes: {
        children: React.PropTypes.node,
        primary: React.PropTypes.bool,
        href: React.PropTypes.string
    },

    render: function render() {
        var _props = this.props,
            children = _props.children,
            primary = _props.primary,
            href = _props.href;

        var className = classNames('overview-steptitle', {
            primary: primary
        });

        if (href) {
            return React.createElement(
                'a',
                { href: href, className: className },
                children
            );
        }

        return React.createElement(
            'div',
            { className: className },
            children
        );
    }
});

Overview.StepDivider = React.createClass({
    displayName: 'StepDivider',
    render: function render() {
        return React.createElement(
            'div',
            { className: 'overview-stepdivider' },
            React.createElement(Icon, { id: 'chevron-right' })
        );
    }
});

Overview.Note = React.createClass({
    displayName: 'Note',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'p',
            { className: 'overview-note' },
            this.props.children
        );
    }
});

Overview.Description = React.createClass({
    displayName: 'Description',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'p',
            { className: 'overview-description' },
            this.props.children
        );
    }
});

Overview.Meta = React.createClass({
    displayName: 'Meta',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'overview-meta' },
            this.props.children
        );
    }
});

module.exports = Overview;