'use strict';

var React = require('/Users/jpreynat/Gitbook/styleguide/node_modules/react/react.js');
var classNames = require('classnames');

var Table = React.createClass({
    displayName: 'Table',

    propTypes: {
        bordered: React.PropTypes.bool,
        className: React.PropTypes.string,
        children: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            bordered: false,
            className: ''
        };
    },
    render: function render() {
        var className = classNames('table', { 'table-bordered': this.props.bordered }, this.props.className);

        return React.createElement(
            'table',
            { className: className },
            this.props.children
        );
    }
});

/**
 * ExpendableBody creates a <tbody> element displaying only `display` elements by default
 * If the number of elements is larger than the original `display` prop, a `Show More`
 * button is appended as the last row of the <tbody>. Clicking on it will display `step`
 * more elements each time, until every element is renderded.
 *
 * The elements to display are passed through the `data` prop as an array.
 * Each item of the array can either be:
 *     - a value: the default is to render a single cell with the value for this row
 *     - an array of values: the default is to render each value in a cell for this row
 *     - an object
 *
 * To render an object or customize the display of value(s), the `renderRow` prop accepts
 * a function to which is passed the current row item (value, array or object) and the row index.
 * It must return the corresponding row <tr key={index}> element.
 *
 * Finally, the `cols` prop is used to correctly display the `Show More` button in the table when
 * passing an array of objects to `data`.
 *
 * The `center` props allows for centering all values rendered by default.
 */

var ExpendableBody = React.createClass({
    displayName: 'ExpendableBody',

    propTypes: {
        data: React.PropTypes.array.isRequired,
        display: React.PropTypes.number,
        step: React.PropTypes.number,
        cols: React.PropTypes.string,
        renderRow: React.PropTypes.func,
        center: React.PropTypes.bool
    },

    getDefaultProps: function getDefaultProps() {
        return {
            display: 5,
            step: 5,
            cols: 1,
            center: false
        };
    },
    getInitialState: function getInitialState() {
        return {
            limit: this.props.display
        };
    },
    isArray: function isArray(o) {
        return Object.prototype.toString.call(o) == '[object Array]';
    },
    defaultRenderRow: function defaultRenderRow(item, i) {
        var className = classNames({
            'text-center': this.props.center
        });

        // Array of values per row
        if (this.isArray(item)) {
            return React.createElement(
                'tr',
                { key: i },
                item.map(function (value, j) {
                    return React.createElement(
                        'td',
                        { className: className, key: j },
                        value
                    );
                })
            );
        } else {
            // Single value
            return React.createElement(
                'tr',
                { key: i },
                React.createElement(
                    'td',
                    { className: className },
                    item
                )
            );
        }
    },
    showMore: function showMore() {
        var step = this.props.step;
        var limit = this.state.limit;


        this.setState({
            limit: limit + step
        });
    },
    renderShowMore: function renderShowMore() {
        var _props = this.props,
            data = _props.data,
            cols = _props.cols,
            step = _props.step;
        var limit = this.state.limit;

        var length = data.length;

        // Don't display when everything's on the screen
        if (limit >= length) {
            return null;
        }

        // Try to get colSpan from data if array
        if (Boolean(length) && this.isArray(data[0])) {
            cols = data[0].length.toString();
        }

        return React.createElement(
            'tr',
            null,
            React.createElement(
                'td',
                { className: 'text-center', colSpan: cols },
                React.createElement(
                    'div',
                    { className: 'show-more', onClick: this.showMore },
                    'Show ',
                    step,
                    ' more (',
                    length - limit,
                    ')'
                )
            )
        );
    },
    renderRow: function renderRow(item, i) {
        var renderRow = this.props.renderRow || this.defaultRenderRow;
        return renderRow(item, i);
    },
    render: function render() {
        var data = this.props.data;
        var limit = this.state.limit;


        return React.createElement(
            'tbody',
            { className: 'table-body-expendable' },
            data.slice(0, limit).map(this.renderRow, this),
            this.renderShowMore()
        );
    }
});

module.exports = Table;
module.exports.ExpendableBody = ExpendableBody;