'use strict';

var React = require('react');
var classNames = require('classnames');

var Icon = require('./icon');

var PADDING_INITIAL = 10;
var DEPTH_PADDING = 18;

var STATUS = ['danger', 'success', 'warning', 'selected'];

/**
 * Tree component:
 *
 * <Tree>
 *      <Tree.Node>
 *          <Tree.Leaf>
 *              <Tree.Toggle /> My Directory
 *          </Tree.Leaf>
 *          <Tree>...</Tree>
 *      </Tree.Node>
 *      <Tree.Node>
 *          <Tree.Leaf>My File</Tree.Leaf>
 *      </Tree.Node>
 * </Tree>
 */

var Tree = React.createClass({
    displayName: 'Tree',

    propTypes: {
        children: React.PropTypes.node,
        depth: React.PropTypes.number
    },
    contextTypes: {
        depth: React.PropTypes.number
    },
    childContextTypes: {
        depth: React.PropTypes.number
    },

    getChildContext: function getChildContext() {
        var depth = this.props.depth || this.context.depth || 0;

        return {
            depth: depth + 1
        };
    },
    render: function render() {
        return React.createElement(
            'div',
            { className: 'Tree' },
            this.props.children
        );
    }
});

var TreeNode = React.createClass({
    displayName: 'TreeNode',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'TreeNode' },
            this.props.children
        );
    }
});

/**
 * Inner content of a tree node
 */
var TreeLeaf = React.createClass({
    displayName: 'TreeLeaf',

    propTypes: {
        children: React.PropTypes.node,
        href: React.PropTypes.string,
        onClick: React.PropTypes.func,
        status: React.PropTypes.oneOf(STATUS)
    },
    contextTypes: {
        depth: React.PropTypes.number
    },

    getDefaultProps: function getDefaultProps() {
        return {
            href: '#'
        };
    },
    onClick: function onClick(event) {
        var onClick = this.props.onClick;

        if (!onClick) {
            return;
        }

        event.preventDefault();
        onClick();
    },
    render: function render() {
        var _props = this.props,
            href = _props.href,
            status = _props.status;
        var depth = this.context.depth;


        var style = {
            paddingLeft: PADDING_INITIAL + depth * DEPTH_PADDING
        };

        var className = classNames('TreeLeaf', status ? 'status-' + status : '');

        return React.createElement(
            'a',
            { className: className, href: href, style: style },
            this.props.children
        );
    }
});

/**
 * Little triangle to toggle sub-tree.
 * Insert a TreeToggle in a TreeLeaf
 */
var TreeToggle = React.createClass({
    displayName: 'TreeToggle',

    propTypes: {
        active: React.PropTypes.bool,
        onClick: React.PropTypes.func
    },

    onClick: function onClick(event) {
        var onClick = this.props.onClick;


        event.preventDefault();
        event.stopPropagation();

        if (onClick) onClick();
    },
    render: function render() {
        var active = this.props.active;

        var className = classNames('TreeToggle', {
            active: active
        });

        return React.createElement(
            'span',
            { className: className },
            React.createElement(Icon, { id: active ? 'triangle-down' : 'triangle-right' })
        );
    }
});

module.exports = Tree;
module.exports.Node = TreeNode;
module.exports.Leaf = TreeLeaf;
module.exports.Toggle = TreeToggle;
//# sourceMappingURL=data:application/json;base64,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