'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var React = require('react');
var classNames = require('classnames');

var Icon = require('./Icon');
var STYLES = require('./STYLES');
var SIZES = require('./SIZES');

var BUTTONS_STYLES = STYLES.concat(['link', 'marketing-primary', 'secondary', 'count']);

var Button = React.createClass({
    displayName: 'Button',

    propTypes: {
        className: React.PropTypes.string,
        children: React.PropTypes.node,
        type: React.PropTypes.string,
        size: React.PropTypes.oneOf(SIZES),
        style: React.PropTypes.oneOf(BUTTONS_STYLES),
        // Makes a link button
        href: React.PropTypes.string,
        // Form button
        value: React.PropTypes.oneOfType([React.PropTypes.string, React.PropTypes.bool, React.PropTypes.number]),
        name: React.PropTypes.string,
        // For links
        target: React.PropTypes.string,
        filled: React.PropTypes.bool,
        noBorder: React.PropTypes.bool,
        disabled: React.PropTypes.bool,
        active: React.PropTypes.bool,
        block: React.PropTypes.bool,
        dropdownToggle: React.PropTypes.bool,
        onClick: React.PropTypes.func,
        title: React.PropTypes.string,
        icon: React.PropTypes.string
    },

    getInitialState: function getInitialState() {
        return {
            clicked: false
        };
    },
    getDefaultProps: function getDefaultProps() {
        return {
            style: 'default',
            size: 'md',
            type: 'button',
            filled: false,
            disabled: false,
            active: false
        };
    },
    onClick: function onClick(e) {
        var _this = this;

        // Prevent any action if button is disabled
        var disabled = this.props.disabled;

        if (disabled) {
            e.preventDefault();
            return;
        }

        var clicked = this.state.clicked;

        if (this.props.onClick && !clicked) {
            this.props.onClick(e);
        }

        if (!this.isFormButton()) {
            return;
        } else if (clicked) {
            return this.setState({
                clicked: false
            });
        }

        // Add this submitting button's value to the form as hidden
        // input. Only after that do the click.
        // This fixes issues with PJAX[1] in Firefox[2]
        // [1]: https://github.com/defunkt/jquery-pjax/pull/295
        // [2]: http://stackoverflow.com/questions/38277900/formdata-object-does-not-add-submit-type-inputs-from-form-while-on-firefox
        e.preventDefault();
        this.setState({
            clicked: true
        }, function () {
            _this.refs.button.click();
        });
    },
    isFormButton: function isFormButton() {
        var _props = this.props,
            type = _props.type,
            name = _props.name;

        return type === 'submit' && name;
    },
    render: function render() {
        var clicked = this.state.clicked;

        var _props2 = this.props,
            title = _props2.title,
            icon = _props2.icon,
            filled = _props2.filled,
            block = _props2.block,
            noBorder = _props2.noBorder,
            active = _props2.active,
            dropdownToggle = _props2.dropdownToggle,
            style = _props2.style,
            size = _props2.size,
            className = _props2.className,
            children = _props2.children,
            name = _props2.name,
            value = _props2.value,
            disabled = _props2.disabled,
            props = _objectWithoutProperties(_props2, ['title', 'icon', 'filled', 'block', 'noBorder', 'active', 'dropdownToggle', 'style', 'size', 'className', 'children', 'name', 'value', 'disabled']);

        var inner = icon ? React.createElement(Icon, { className: icon }) : '';

        props.className = classNames('btn', 'btn-' + style, 'btn-' + size, className, {
            'btn-fill': filled,
            'btn-block': block,
            'btn-noborder': noBorder,
            active: active, disabled: disabled,
            'dropdown-toggle': dropdownToggle,
            'tooltipped': Boolean(title)
        });
        props['aria-label'] = title;
        props.role = 'button';
        props.disabled = disabled;
        props.onClick = this.onClick;
        // Update href if button is disabled
        props.href = disabled ? '#' : props.href;

        var input = void 0;

        if (clicked && this.isFormButton()) {
            input = React.createElement('input', { type: 'hidden', name: name, value: value });
        }

        if (props.href) {
            delete props.type;
            return React.createElement(
                'a',
                props,
                inner,
                ' ',
                children
            );
        } else {
            return React.createElement(
                'button',
                _extends({ ref: 'button' }, props),
                inner,
                ' ',
                children,
                input
            );
        }
    }
});

var ButtonGroup = React.createClass({
    displayName: 'ButtonGroup',

    propTypes: {
        className: React.PropTypes.string,
        children: React.PropTypes.node,
        pull: React.PropTypes.string,
        block: React.PropTypes.bool
    },

    render: function render() {
        var _props3 = this.props,
            className = _props3.className,
            pull = _props3.pull,
            children = _props3.children,
            block = _props3.block,
            props = _objectWithoutProperties(_props3, ['className', 'pull', 'children', 'block']);

        className = classNames('btn-group', className, pull ? 'pull-' + pull : '', {
            'btn-group-block': block
        });

        return React.createElement(
            'div',
            _extends({ className: className }, props),
            children
        );
    }
});

var ButtonToolbar = React.createClass({
    displayName: 'ButtonToolbar',

    propTypes: {
        className: React.PropTypes.string,
        children: React.PropTypes.node
    },

    render: function render() {
        var _props4 = this.props,
            className = _props4.className,
            children = _props4.children,
            props = _objectWithoutProperties(_props4, ['className', 'children']);

        return React.createElement(
            'div',
            _extends({ className: 'btn-toolbar ' + (className || '') }, props),
            children
        );
    }
});

var ButtonCaret = React.createClass({
    displayName: 'ButtonCaret',
    render: function render() {
        return React.createElement('span', { className: 'caret' });
    }
});

var ButtonTextExpander = React.createClass({
    displayName: 'ButtonTextExpander',

    propTypes: {
        onClick: React.PropTypes.func
    },

    onClick: function onClick(e) {
        if (this.props.onClick) {
            this.props.onClick();
        }
    },
    render: function render() {
        return React.createElement(
            'span',
            { className: 'hidden-text-expander' },
            React.createElement(
                'button',
                { type: 'button', className: 'ellipsis-expander', onClick: this.onClick },
                '\u2026'
            )
        );
    }
});

module.exports = Button;
module.exports.Group = ButtonGroup;
module.exports.Toolbar = ButtonToolbar;
module.exports.Caret = ButtonCaret;
module.exports.TextExpander = ButtonTextExpander;
module.exports.STYLES = BUTTONS_STYLES;
//# sourceMappingURL=data:application/json;base64,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