'use strict';

var React = require('react');
var classNames = require('classnames');

var Icon = require('./Icon');
var Form = require('./Form');
var Input = require('./Input');

var SearchBar = React.createClass({
    displayName: 'SearchBar',

    propTypes: {
        className: React.PropTypes.string,
        placeholder: React.PropTypes.string,
        value: React.PropTypes.string,
        action: React.PropTypes.string,
        name: React.PropTypes.string,
        method: React.PropTypes.string,
        onSubmit: React.PropTypes.func,
        onChange: React.PropTypes.func
    },

    getDefaultProps: function getDefaultProps() {
        return {
            method: 'get'
        };
    },
    getInitialState: function getInitialState() {
        return {
            value: this.props.value
        };
    },
    componentWillReceiveProps: function componentWillReceiveProps(newProps) {
        this.setState({
            value: newProps.value
        });
    },
    onChange: function onChange(e) {
        var value = e.target.value;


        this.setState({ value: value });

        if (this.props.onChange) {
            this.props.onChange(value);
        }
    },
    onSubmit: function onSubmit(e) {
        if (this.props.onSubmit) {
            e.preventDefault();
            this.props.onSubmit(this.state.value);
        }
    },
    render: function render() {
        var _props = this.props,
            action = _props.action,
            placeholder = _props.placeholder,
            name = _props.name,
            method = _props.method;
        var value = this.state.value;


        return React.createElement(
            Form,
            { className: classNames('search-bar', this.props.className),
                method: method,
                action: action },
            React.createElement(Icon, { id: 'search', size: 'sm' }),
            React.createElement(Input, { name: name,
                value: value,
                onChange: this.onChange,
                placeholder: placeholder })
        );
    }
});

module.exports = SearchBar;
//# sourceMappingURL=data:application/json;base64,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