webpackHotUpdate(5,{

/***/ 552:
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process, __resourceQuery) {

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = __webpack_require__(2);

var Page = __webpack_require__(390);
var Example = __webpack_require__(393);
var CodeEditor = __webpack_require__(168);

var Panel = __webpack_require__(103);
var Modal = __webpack_require__(754);
var Button = __webpack_require__(174);
var Backdrop = __webpack_require__(424);

var SCOPE = { React: React, Modal: Modal, Button: Button, Backdrop: Backdrop };

var EXAMPLE_IMPORT = 'const Modal = require(\'gitbook-styleguide/lib/Modal\');';

var EXAMPLE_DEFAULT = '<Modal animated={false}>\n    <Modal.Heading title="Title" />\n    <Modal.Body>\n        Body of the modal\n    </Modal.Body>\n    <Modal.Footer>\n        <Button style="secondary">Cancel</Button>\n        <Button style="primary">Important action</Button>\n    </Modal.Footer>\n</Modal>';

var EXAMPLE_BACKDROP = '\n<Button onClick={event => this.setState({ open: true })}>Open modal</Button>\n{this.state.open ?\n    <Backdrop wrapper={<Modal.Backdrop />} onClose={event => this.setState({ open: false })}>\n        <Modal>\n            <Modal.Heading title="Title" />\n            <Modal.Body>\n                Body of the modal\n            </Modal.Body>\n            <Modal.Footer>\n                <Button style="secondary" onClick={event => this.setState({ open: false })}>Cancel</Button>\n                <Button style="primary">Important action</Button>\n            </Modal.Footer>\n        </Modal>\n    </Backdrop>\n: null}';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Modals', active: 'modals' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Modals' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(
                    'p',
                    null,
                    'Modals are streamlined, but flexible, dialog prompts with the minimum required functionality and smart defaults.'
                ),
                React.createElement(CodeEditor, { source: EXAMPLE_IMPORT })
            )
        ),
        React.createElement(Example, { title: 'Example', source: EXAMPLE_DEFAULT, scope: SCOPE }),
        React.createElement(Example, { title: 'With a backdrop', source: EXAMPLE_BACKDROP, scope: SCOPE })
    );
};
//# sourceMappingURL=data:application/json;base64,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

 ;(function register() { /* react-hot-loader/webpack */ if (process.env.NODE_ENV !== 'production') { if (typeof __REACT_HOT_LOADER__ === 'undefined') { return; } if (typeof module.exports === 'function') { __REACT_HOT_LOADER__.register(module.exports, 'module.exports', "/Users/nicolas/Prog/GitBook/styleguide/pages/modals.js"); return; } for (var key in module.exports) { if (!Object.prototype.hasOwnProperty.call(module.exports, key)) { continue; } var namedExport = void 0; try { namedExport = module.exports[key]; } catch (err) { continue; } __REACT_HOT_LOADER__.register(namedExport, key, "/Users/nicolas/Prog/GitBook/styleguide/pages/modals.js"); } } })();
    (function (Component, route) {
      if (false) return
      if (false) return

      var qs = __webpack_require__(49)
      var params = qs.parse(__resourceQuery.slice(1))
      if (params.entry == null) return

      module.hot.accept()
      Component.__route = route

      if (module.hot.status() === 'idle') return

      var components = next.router.components
      for (var r in components) {
        if (!components.hasOwnProperty(r)) continue

        if (components[r].Component.__route === route) {
          next.router.update(r, Component)
        }
      }
    })(module.exports.default || module.exports, "/modals")
  
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(0), "?entry"))

/***/ },

/***/ 754:
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {

var React = __webpack_require__(2);
var classNames = __webpack_require__(12);

var SIZES = __webpack_require__(106);

var Modal = React.createClass({
    displayName: 'Modal',

    propTypes: {
        size: React.PropTypes.oneOf(SIZES),
        backdrop: React.PropTypes.bool,
        animated: React.PropTypes.bool,
        children: React.PropTypes.node,
        className: React.PropTypes.string
    },

    getDefaultProps: function getDefaultProps() {
        return {
            size: 'md',
            backdrop: true,
            animated: true
        };
    },
    render: function render() {
        var _props = this.props,
            size = _props.size,
            backdrop = _props.backdrop,
            animated = _props.animated,
            children = _props.children;


        var className = classNames('modal', 'modal-' + size, this.props.className, {
            animated: animated,
            'without-backdrop': !backdrop
        });

        return React.createElement(
            'div',
            { className: className },
            children
        );
    }
});

var ModalBackdrop = React.createClass({
    displayName: 'ModalBackdrop',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'modal-backdrop ' },
            this.props.children
        );
    }
});

var ModalBody = React.createClass({
    displayName: 'ModalBody',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'modal-body' },
            this.props.children
        );
    }
});

var ModalFooter = React.createClass({
    displayName: 'ModalFooter',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'modal-footer ' },
            this.props.children
        );
    }
});

var ModalHeading = React.createClass({
    displayName: 'ModalHeading',

    propTypes: {
        children: React.PropTypes.node,
        onClose: React.PropTypes.func,
        title: React.PropTypes.string
    },

    onClose: function onClose(e) {
        e.preventDefault();
        this.props.onClose();
    },
    render: function render() {
        if (this.props.title) {
            return React.createElement(
                'div',
                { className: 'modal-heading' },
                React.createElement(
                    'h4',
                    null,
                    this.props.title
                ),
                this.props.onClose ? React.createElement(
                    'a',
                    { href: '#', onClick: this.onClose, className: 'modal-close' },
                    '\xD7'
                ) : ''
            );
        }

        return React.createElement(
            'div',
            { className: 'modal-heading' },
            this.props.children
        );
    }
});

module.exports = Modal;
module.exports.Backdrop = ModalBackdrop;
module.exports.Body = ModalBody;
module.exports.Footer = ModalFooter;
module.exports.Heading = ModalHeading;
//# sourceMappingURL=data:application/json;base64,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

 ;(function register() { /* react-hot-loader/webpack */ if (process.env.NODE_ENV !== 'production') { if (typeof __REACT_HOT_LOADER__ === 'undefined') { return; } if (typeof module.exports === 'function') { __REACT_HOT_LOADER__.register(module.exports, 'module.exports', "/Users/nicolas/Prog/GitBook/styleguide/src/Modal.js"); return; } for (var key in module.exports) { if (!Object.prototype.hasOwnProperty.call(module.exports, key)) { continue; } var namedExport = void 0; try { namedExport = module.exports[key]; } catch (err) { continue; } __REACT_HOT_LOADER__.register(namedExport, key, "/Users/nicolas/Prog/GitBook/styleguide/src/Modal.js"); } } })();
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(0)))

/***/ }

})
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9wYWdlcy9tb2RhbHMuanM/OWU5OCIsIndlYnBhY2s6Ly8vLi9zcmMvTW9kYWwuanM/ZjA3ZSJdLCJuYW1lcyI6WyJSZWFjdCIsInJlcXVpcmUiLCJQYWdlIiwiRXhhbXBsZSIsIkNvZGVFZGl0b3IiLCJQYW5lbCIsIk1vZGFsIiwiQnV0dG9uIiwiQmFja2Ryb3AiLCJTQ09QRSIsIkVYQU1QTEVfSU1QT1JUIiwiRVhBTVBMRV9ERUZBVUxUIiwiRVhBTVBMRV9CQUNLRFJPUCIsImNsYXNzTmFtZXMiLCJTSVpFUyIsImNyZWF0ZUNsYXNzIiwicHJvcFR5cGVzIiwic2l6ZSIsIlByb3BUeXBlcyIsIm9uZU9mIiwiYmFja2Ryb3AiLCJib29sIiwiYW5pbWF0ZWQiLCJjaGlsZHJlbiIsIm5vZGUiLCJjbGFzc05hbWUiLCJzdHJpbmciLCJnZXREZWZhdWx0UHJvcHMiLCJyZW5kZXIiLCJwcm9wcyIsIk1vZGFsQmFja2Ryb3AiLCJNb2RhbEJvZHkiLCJNb2RhbEZvb3RlciIsIk1vZGFsSGVhZGluZyIsIm9uQ2xvc2UiLCJmdW5jIiwidGl0bGUiLCJlIiwicHJldmVudERlZmF1bHQiLCJtb2R1bGUiLCJleHBvcnRzIiwiQm9keSIsIkZvb3RlciIsIkhlYWRpbmciXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7O0FBQUEsSUFBTUEsUUFBUSxtQkFBQUMsQ0FBUSxDQUFSLENBQWQ7O0FBRUEsSUFBTUMsT0FBTyxtQkFBQUQsQ0FBUSxHQUFSLENBQWI7QUFDQSxJQUFNRSxVQUFVLG1CQUFBRixDQUFRLEdBQVIsQ0FBaEI7QUFDQSxJQUFNRyxhQUFhLG1CQUFBSCxDQUFRLEdBQVIsQ0FBbkI7O0FBRUEsSUFBTUksUUFBUSxtQkFBQUosQ0FBUSxHQUFSLENBQWQ7QUFDQSxJQUFNSyxRQUFRLG1CQUFBTCxDQUFRLEdBQVIsQ0FBZDtBQUNBLElBQU1NLFNBQVMsbUJBQUFOLENBQVEsR0FBUixDQUFmO0FBQ0EsSUFBTU8sV0FBVyxtQkFBQVAsQ0FBUSxHQUFSLENBQWpCOztBQUVBLElBQU1RLFFBQVEsRUFBRVQsWUFBRixFQUFTTSxZQUFULEVBQWdCQyxjQUFoQixFQUF3QkMsa0JBQXhCLEVBQWQ7O0FBRUEsSUFBTUUsaUJBQ04sMERBREE7O0FBR0EsSUFBTUMsa1RBQU47O0FBWUEsSUFBTUMsaW9CQUFOOztrQkFrQmUsWUFBTTtBQUNqQixXQUNJO0FBQUMsWUFBRDtBQUFBLFVBQU0sT0FBTSxRQUFaLEVBQXFCLFFBQU8sUUFBNUI7QUFDSTtBQUFDLGlCQUFEO0FBQUE7QUFDSSxnQ0FBQyxLQUFELENBQU8sT0FBUCxJQUFlLE9BQU0sUUFBckIsR0FESjtBQUVJO0FBQUMscUJBQUQsQ0FBTyxJQUFQO0FBQUE7QUFDSTtBQUFBO0FBQUE7QUFBQTtBQUFBLGlCQURKO0FBRUksb0NBQUMsVUFBRCxJQUFZLFFBQVFGLGNBQXBCO0FBRko7QUFGSixTQURKO0FBU0ksNEJBQUMsT0FBRCxJQUFTLE9BQU0sU0FBZixFQUF5QixRQUFRQyxlQUFqQyxFQUFrRCxPQUFPRixLQUF6RCxHQVRKO0FBVUksNEJBQUMsT0FBRCxJQUFTLE9BQU0saUJBQWYsRUFBaUMsUUFBUUcsZ0JBQXpDLEVBQTJELE9BQU9ILEtBQWxFO0FBVkosS0FESjtBQWNILEM7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUM3REQsSUFBTVQsUUFBUSxtQkFBQUMsQ0FBUSxDQUFSLENBQWQ7QUFDQSxJQUFNWSxhQUFhLG1CQUFBWixDQUFRLEVBQVIsQ0FBbkI7O0FBRUEsSUFBTWEsUUFBUSxtQkFBQWIsQ0FBUSxHQUFSLENBQWQ7O0FBRUEsSUFBTUssUUFBUU4sTUFBTWUsV0FBTixDQUFrQjtBQUFBOztBQUM1QkMsZUFBVztBQUNQQyxjQUFVakIsTUFBTWtCLFNBQU4sQ0FBZ0JDLEtBQWhCLENBQXNCTCxLQUF0QixDQURIO0FBRVBNLGtCQUFVcEIsTUFBTWtCLFNBQU4sQ0FBZ0JHLElBRm5CO0FBR1BDLGtCQUFVdEIsTUFBTWtCLFNBQU4sQ0FBZ0JHLElBSG5CO0FBSVBFLGtCQUFVdkIsTUFBTWtCLFNBQU4sQ0FBZ0JNLElBSm5CO0FBS1BDLG1CQUFXekIsTUFBTWtCLFNBQU4sQ0FBZ0JRO0FBTHBCLEtBRGlCOztBQVM1QkMsbUJBVDRCLDZCQVNWO0FBQ2QsZUFBTztBQUNIVixrQkFBTSxJQURIO0FBRUhHLHNCQUFVLElBRlA7QUFHSEUsc0JBQVU7QUFIUCxTQUFQO0FBS0gsS0FmMkI7QUFpQjVCTSxVQWpCNEIsb0JBaUJuQjtBQUFBLHFCQUlELEtBQUtDLEtBSko7QUFBQSxZQUVEWixJQUZDLFVBRURBLElBRkM7QUFBQSxZQUVLRyxRQUZMLFVBRUtBLFFBRkw7QUFBQSxZQUdERSxRQUhDLFVBR0RBLFFBSEM7QUFBQSxZQUdTQyxRQUhULFVBR1NBLFFBSFQ7OztBQU1MLFlBQU1FLFlBQVlaLFdBQ2QsT0FEYyxFQUVkLFdBQVdJLElBRkcsRUFHZCxLQUFLWSxLQUFMLENBQVdKLFNBSEcsRUFJZDtBQUNJSCw4QkFESjtBQUVJLGdDQUFvQixDQUFDRjtBQUZ6QixTQUpjLENBQWxCOztBQVNBLGVBQ0k7QUFBQTtBQUFBLGNBQUssV0FBV0ssU0FBaEI7QUFDS0Y7QUFETCxTQURKO0FBS0g7QUFyQzJCLENBQWxCLENBQWQ7O0FBd0NBLElBQU1PLGdCQUFnQjlCLE1BQU1lLFdBQU4sQ0FBa0I7QUFBQTs7QUFDcENDLGVBQVc7QUFDUE8sa0JBQVV2QixNQUFNa0IsU0FBTixDQUFnQk07QUFEbkIsS0FEeUI7O0FBS3BDSSxVQUxvQyxvQkFLM0I7QUFDTCxlQUNJO0FBQUE7QUFBQSxjQUFLLFdBQVUsaUJBQWY7QUFDSyxpQkFBS0MsS0FBTCxDQUFXTjtBQURoQixTQURKO0FBS0g7QUFYbUMsQ0FBbEIsQ0FBdEI7O0FBY0EsSUFBTVEsWUFBWS9CLE1BQU1lLFdBQU4sQ0FBa0I7QUFBQTs7QUFDaENDLGVBQVc7QUFDUE8sa0JBQVV2QixNQUFNa0IsU0FBTixDQUFnQk07QUFEbkIsS0FEcUI7O0FBS2hDSSxVQUxnQyxvQkFLdkI7QUFDTCxlQUNJO0FBQUE7QUFBQSxjQUFLLFdBQVUsWUFBZjtBQUNLLGlCQUFLQyxLQUFMLENBQVdOO0FBRGhCLFNBREo7QUFLSDtBQVgrQixDQUFsQixDQUFsQjs7QUFjQSxJQUFNUyxjQUFjaEMsTUFBTWUsV0FBTixDQUFrQjtBQUFBOztBQUNsQ0MsZUFBVztBQUNQTyxrQkFBVXZCLE1BQU1rQixTQUFOLENBQWdCTTtBQURuQixLQUR1Qjs7QUFLbENJLFVBTGtDLG9CQUt6QjtBQUNMLGVBQ0k7QUFBQTtBQUFBLGNBQUssV0FBVSxlQUFmO0FBQ0ssaUJBQUtDLEtBQUwsQ0FBV047QUFEaEIsU0FESjtBQUtIO0FBWGlDLENBQWxCLENBQXBCOztBQWNBLElBQU1VLGVBQWVqQyxNQUFNZSxXQUFOLENBQWtCO0FBQUE7O0FBQ25DQyxlQUFXO0FBQ1BPLGtCQUFVdkIsTUFBTWtCLFNBQU4sQ0FBZ0JNLElBRG5CO0FBRVBVLGlCQUFVbEMsTUFBTWtCLFNBQU4sQ0FBZ0JpQixJQUZuQjtBQUdQQyxlQUFVcEMsTUFBTWtCLFNBQU4sQ0FBZ0JRO0FBSG5CLEtBRHdCOztBQU9uQ1EsV0FQbUMsbUJBTzNCRyxDQVAyQixFQU94QjtBQUNQQSxVQUFFQyxjQUFGO0FBQ0EsYUFBS1QsS0FBTCxDQUFXSyxPQUFYO0FBQ0gsS0FWa0M7QUFZbkNOLFVBWm1DLG9CQVkxQjtBQUNMLFlBQUksS0FBS0MsS0FBTCxDQUFXTyxLQUFmLEVBQXNCO0FBQ2xCLG1CQUNJO0FBQUE7QUFBQSxrQkFBSyxXQUFVLGVBQWY7QUFDSTtBQUFBO0FBQUE7QUFBSyx5QkFBS1AsS0FBTCxDQUFXTztBQUFoQixpQkFESjtBQUVLLHFCQUFLUCxLQUFMLENBQVdLLE9BQVgsR0FBcUI7QUFBQTtBQUFBLHNCQUFHLE1BQUssR0FBUixFQUFZLFNBQVMsS0FBS0EsT0FBMUIsRUFBbUMsV0FBVSxhQUE3QztBQUFBO0FBQUEsaUJBQXJCLEdBQThGO0FBRm5HLGFBREo7QUFNSDs7QUFFRCxlQUNJO0FBQUE7QUFBQSxjQUFLLFdBQVUsZUFBZjtBQUNLLGlCQUFLTCxLQUFMLENBQVdOO0FBRGhCLFNBREo7QUFLSDtBQTNCa0MsQ0FBbEIsQ0FBckI7O0FBOEJBZ0IsT0FBT0MsT0FBUCxHQUEwQmxDLEtBQTFCO0FBQ0FpQyxPQUFPQyxPQUFQLENBQWVoQyxRQUFmLEdBQTBCc0IsYUFBMUI7QUFDQVMsT0FBT0MsT0FBUCxDQUFlQyxJQUFmLEdBQTBCVixTQUExQjtBQUNBUSxPQUFPQyxPQUFQLENBQWVFLE1BQWYsR0FBMEJWLFdBQTFCO0FBQ0FPLE9BQU9DLE9BQVAsQ0FBZUcsT0FBZixHQUEwQlYsWUFBMUIiLCJmaWxlIjoiNS5lYzI3NjEzMDU0NzU4YTJjYTljNS5ob3QtdXBkYXRlLmpzIiwic291cmNlc0NvbnRlbnQiOlsiY29uc3QgUmVhY3QgPSByZXF1aXJlKCdyZWFjdCcpO1xuXG5jb25zdCBQYWdlID0gcmVxdWlyZSgnLi9jb21wb25lbnRzL1BhZ2UnKTtcbmNvbnN0IEV4YW1wbGUgPSByZXF1aXJlKCcuL2NvbXBvbmVudHMvRXhhbXBsZScpO1xuY29uc3QgQ29kZUVkaXRvciA9IHJlcXVpcmUoJy4vY29tcG9uZW50cy9Db2RlRWRpdG9yJyk7XG5cbmNvbnN0IFBhbmVsID0gcmVxdWlyZSgnLi4vc3JjL1BhbmVsJyk7XG5jb25zdCBNb2RhbCA9IHJlcXVpcmUoJy4uL3NyYy9Nb2RhbCcpO1xuY29uc3QgQnV0dG9uID0gcmVxdWlyZSgnLi4vc3JjL0J1dHRvbicpO1xuY29uc3QgQmFja2Ryb3AgPSByZXF1aXJlKCcuLi9zcmMvQmFja2Ryb3AnKTtcblxuY29uc3QgU0NPUEUgPSB7IFJlYWN0LCBNb2RhbCwgQnV0dG9uLCBCYWNrZHJvcCB9O1xuXG5jb25zdCBFWEFNUExFX0lNUE9SVCA9XG4nY29uc3QgTW9kYWwgPSByZXF1aXJlKFxcJ2dpdGJvb2stc3R5bGVndWlkZS9saWIvTW9kYWxcXCcpOyc7XG5cbmNvbnN0IEVYQU1QTEVfREVGQVVMVCA9XG5gPE1vZGFsIGFuaW1hdGVkPXtmYWxzZX0+XG4gICAgPE1vZGFsLkhlYWRpbmcgdGl0bGU9XCJUaXRsZVwiIC8+XG4gICAgPE1vZGFsLkJvZHk+XG4gICAgICAgIEJvZHkgb2YgdGhlIG1vZGFsXG4gICAgPC9Nb2RhbC5Cb2R5PlxuICAgIDxNb2RhbC5Gb290ZXI+XG4gICAgICAgIDxCdXR0b24gc3R5bGU9XCJzZWNvbmRhcnlcIj5DYW5jZWw8L0J1dHRvbj5cbiAgICAgICAgPEJ1dHRvbiBzdHlsZT1cInByaW1hcnlcIj5JbXBvcnRhbnQgYWN0aW9uPC9CdXR0b24+XG4gICAgPC9Nb2RhbC5Gb290ZXI+XG48L01vZGFsPmA7XG5cbmNvbnN0IEVYQU1QTEVfQkFDS0RST1AgPVxuYFxuPEJ1dHRvbiBvbkNsaWNrPXtldmVudCA9PiB0aGlzLnNldFN0YXRlKHsgb3BlbjogdHJ1ZSB9KX0+T3BlbiBtb2RhbDwvQnV0dG9uPlxue3RoaXMuc3RhdGUub3BlbiA/XG4gICAgPEJhY2tkcm9wIHdyYXBwZXI9ezxNb2RhbC5CYWNrZHJvcCAvPn0gb25DbG9zZT17ZXZlbnQgPT4gdGhpcy5zZXRTdGF0ZSh7IG9wZW46IGZhbHNlIH0pfT5cbiAgICAgICAgPE1vZGFsPlxuICAgICAgICAgICAgPE1vZGFsLkhlYWRpbmcgdGl0bGU9XCJUaXRsZVwiIC8+XG4gICAgICAgICAgICA8TW9kYWwuQm9keT5cbiAgICAgICAgICAgICAgICBCb2R5IG9mIHRoZSBtb2RhbFxuICAgICAgICAgICAgPC9Nb2RhbC5Cb2R5PlxuICAgICAgICAgICAgPE1vZGFsLkZvb3Rlcj5cbiAgICAgICAgICAgICAgICA8QnV0dG9uIHN0eWxlPVwic2Vjb25kYXJ5XCIgb25DbGljaz17ZXZlbnQgPT4gdGhpcy5zZXRTdGF0ZSh7IG9wZW46IGZhbHNlIH0pfT5DYW5jZWw8L0J1dHRvbj5cbiAgICAgICAgICAgICAgICA8QnV0dG9uIHN0eWxlPVwicHJpbWFyeVwiPkltcG9ydGFudCBhY3Rpb248L0J1dHRvbj5cbiAgICAgICAgICAgIDwvTW9kYWwuRm9vdGVyPlxuICAgICAgICA8L01vZGFsPlxuICAgIDwvQmFja2Ryb3A+XG46IG51bGx9YDtcblxuZXhwb3J0IGRlZmF1bHQgKCkgPT4ge1xuICAgIHJldHVybiAoXG4gICAgICAgIDxQYWdlIHRpdGxlPVwiTW9kYWxzXCIgYWN0aXZlPVwibW9kYWxzXCI+XG4gICAgICAgICAgICA8UGFuZWw+XG4gICAgICAgICAgICAgICAgPFBhbmVsLkhlYWRpbmcgdGl0bGU9XCJNb2RhbHNcIiAvPlxuICAgICAgICAgICAgICAgIDxQYW5lbC5Cb2R5PlxuICAgICAgICAgICAgICAgICAgICA8cD5Nb2RhbHMgYXJlIHN0cmVhbWxpbmVkLCBidXQgZmxleGlibGUsIGRpYWxvZyBwcm9tcHRzIHdpdGggdGhlIG1pbmltdW0gcmVxdWlyZWQgZnVuY3Rpb25hbGl0eSBhbmQgc21hcnQgZGVmYXVsdHMuPC9wPlxuICAgICAgICAgICAgICAgICAgICA8Q29kZUVkaXRvciBzb3VyY2U9e0VYQU1QTEVfSU1QT1JUfSAvPlxuICAgICAgICAgICAgICAgIDwvUGFuZWwuQm9keT5cbiAgICAgICAgICAgIDwvUGFuZWw+XG5cbiAgICAgICAgICAgIDxFeGFtcGxlIHRpdGxlPVwiRXhhbXBsZVwiIHNvdXJjZT17RVhBTVBMRV9ERUZBVUxUfSBzY29wZT17U0NPUEV9PjwvRXhhbXBsZT5cbiAgICAgICAgICAgIDxFeGFtcGxlIHRpdGxlPVwiV2l0aCBhIGJhY2tkcm9wXCIgc291cmNlPXtFWEFNUExFX0JBQ0tEUk9QfSBzY29wZT17U0NPUEV9PjwvRXhhbXBsZT5cbiAgICAgICAgPC9QYWdlPlxuICAgICk7XG59O1xuXG5cblxuLy8gV0VCUEFDSyBGT09URVIgLy9cbi8vIC4vcGFnZXMvbW9kYWxzLmpzP2VudHJ5IiwiY29uc3QgUmVhY3QgPSByZXF1aXJlKCdyZWFjdCcpO1xuY29uc3QgY2xhc3NOYW1lcyA9IHJlcXVpcmUoJ2NsYXNzbmFtZXMnKTtcblxuY29uc3QgU0laRVMgPSByZXF1aXJlKCcuL1NJWkVTJyk7XG5cbmNvbnN0IE1vZGFsID0gUmVhY3QuY3JlYXRlQ2xhc3Moe1xuICAgIHByb3BUeXBlczoge1xuICAgICAgICBzaXplOiAgICAgUmVhY3QuUHJvcFR5cGVzLm9uZU9mKFNJWkVTKSxcbiAgICAgICAgYmFja2Ryb3A6IFJlYWN0LlByb3BUeXBlcy5ib29sLFxuICAgICAgICBhbmltYXRlZDogUmVhY3QuUHJvcFR5cGVzLmJvb2wsXG4gICAgICAgIGNoaWxkcmVuOiBSZWFjdC5Qcm9wVHlwZXMubm9kZSxcbiAgICAgICAgY2xhc3NOYW1lOiBSZWFjdC5Qcm9wVHlwZXMuc3RyaW5nXG4gICAgfSxcblxuICAgIGdldERlZmF1bHRQcm9wcygpIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIHNpemU6ICdtZCcsXG4gICAgICAgICAgICBiYWNrZHJvcDogdHJ1ZSxcbiAgICAgICAgICAgIGFuaW1hdGVkOiB0cnVlXG4gICAgICAgIH07XG4gICAgfSxcblxuICAgIHJlbmRlcigpIHtcbiAgICAgICAgY29uc3Qge1xuICAgICAgICAgICAgc2l6ZSwgYmFja2Ryb3AsXG4gICAgICAgICAgICBhbmltYXRlZCwgY2hpbGRyZW5cbiAgICAgICAgfSA9IHRoaXMucHJvcHM7XG5cbiAgICAgICAgY29uc3QgY2xhc3NOYW1lID0gY2xhc3NOYW1lcyhcbiAgICAgICAgICAgICdtb2RhbCcsXG4gICAgICAgICAgICAnbW9kYWwtJyArIHNpemUsXG4gICAgICAgICAgICB0aGlzLnByb3BzLmNsYXNzTmFtZSxcbiAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICBhbmltYXRlZCxcbiAgICAgICAgICAgICAgICAnd2l0aG91dC1iYWNrZHJvcCc6ICFiYWNrZHJvcFxuICAgICAgICAgICAgfSk7XG5cbiAgICAgICAgcmV0dXJuIChcbiAgICAgICAgICAgIDxkaXYgY2xhc3NOYW1lPXtjbGFzc05hbWV9PlxuICAgICAgICAgICAgICAgIHtjaGlsZHJlbn1cbiAgICAgICAgICAgIDwvZGl2PlxuICAgICAgICApO1xuICAgIH1cbn0pO1xuXG5jb25zdCBNb2RhbEJhY2tkcm9wID0gUmVhY3QuY3JlYXRlQ2xhc3Moe1xuICAgIHByb3BUeXBlczoge1xuICAgICAgICBjaGlsZHJlbjogUmVhY3QuUHJvcFR5cGVzLm5vZGVcbiAgICB9LFxuXG4gICAgcmVuZGVyKCkge1xuICAgICAgICByZXR1cm4gKFxuICAgICAgICAgICAgPGRpdiBjbGFzc05hbWU9XCJtb2RhbC1iYWNrZHJvcCBcIj5cbiAgICAgICAgICAgICAgICB7dGhpcy5wcm9wcy5jaGlsZHJlbn1cbiAgICAgICAgICAgIDwvZGl2PlxuICAgICAgICApO1xuICAgIH1cbn0pO1xuXG5jb25zdCBNb2RhbEJvZHkgPSBSZWFjdC5jcmVhdGVDbGFzcyh7XG4gICAgcHJvcFR5cGVzOiB7XG4gICAgICAgIGNoaWxkcmVuOiBSZWFjdC5Qcm9wVHlwZXMubm9kZVxuICAgIH0sXG5cbiAgICByZW5kZXIoKSB7XG4gICAgICAgIHJldHVybiAoXG4gICAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT1cIm1vZGFsLWJvZHlcIj5cbiAgICAgICAgICAgICAgICB7dGhpcy5wcm9wcy5jaGlsZHJlbn1cbiAgICAgICAgICAgIDwvZGl2PlxuICAgICAgICApO1xuICAgIH1cbn0pO1xuXG5jb25zdCBNb2RhbEZvb3RlciA9IFJlYWN0LmNyZWF0ZUNsYXNzKHtcbiAgICBwcm9wVHlwZXM6IHtcbiAgICAgICAgY2hpbGRyZW46IFJlYWN0LlByb3BUeXBlcy5ub2RlXG4gICAgfSxcblxuICAgIHJlbmRlcigpIHtcbiAgICAgICAgcmV0dXJuIChcbiAgICAgICAgICAgIDxkaXYgY2xhc3NOYW1lPVwibW9kYWwtZm9vdGVyIFwiPlxuICAgICAgICAgICAgICAgIHt0aGlzLnByb3BzLmNoaWxkcmVufVxuICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICk7XG4gICAgfVxufSk7XG5cbmNvbnN0IE1vZGFsSGVhZGluZyA9IFJlYWN0LmNyZWF0ZUNsYXNzKHtcbiAgICBwcm9wVHlwZXM6IHtcbiAgICAgICAgY2hpbGRyZW46IFJlYWN0LlByb3BUeXBlcy5ub2RlLFxuICAgICAgICBvbkNsb3NlOiAgUmVhY3QuUHJvcFR5cGVzLmZ1bmMsXG4gICAgICAgIHRpdGxlOiAgICBSZWFjdC5Qcm9wVHlwZXMuc3RyaW5nXG4gICAgfSxcblxuICAgIG9uQ2xvc2UoZSkge1xuICAgICAgICBlLnByZXZlbnREZWZhdWx0KCk7XG4gICAgICAgIHRoaXMucHJvcHMub25DbG9zZSgpO1xuICAgIH0sXG5cbiAgICByZW5kZXIoKSB7XG4gICAgICAgIGlmICh0aGlzLnByb3BzLnRpdGxlKSB7XG4gICAgICAgICAgICByZXR1cm4gKFxuICAgICAgICAgICAgICAgIDxkaXYgY2xhc3NOYW1lPVwibW9kYWwtaGVhZGluZ1wiPlxuICAgICAgICAgICAgICAgICAgICA8aDQ+e3RoaXMucHJvcHMudGl0bGV9PC9oND5cbiAgICAgICAgICAgICAgICAgICAge3RoaXMucHJvcHMub25DbG9zZSA/IDxhIGhyZWY9XCIjXCIgb25DbGljaz17dGhpcy5vbkNsb3NlfSBjbGFzc05hbWU9XCJtb2RhbC1jbG9zZVwiPiZ0aW1lczs8L2E+IDogJyd9XG4gICAgICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgICApO1xuICAgICAgICB9XG5cbiAgICAgICAgcmV0dXJuIChcbiAgICAgICAgICAgIDxkaXYgY2xhc3NOYW1lPVwibW9kYWwtaGVhZGluZ1wiPlxuICAgICAgICAgICAgICAgIHt0aGlzLnByb3BzLmNoaWxkcmVufVxuICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICk7XG4gICAgfVxufSk7XG5cbm1vZHVsZS5leHBvcnRzICAgICAgICAgID0gTW9kYWw7XG5tb2R1bGUuZXhwb3J0cy5CYWNrZHJvcCA9IE1vZGFsQmFja2Ryb3A7XG5tb2R1bGUuZXhwb3J0cy5Cb2R5ICAgICA9IE1vZGFsQm9keTtcbm1vZHVsZS5leHBvcnRzLkZvb3RlciAgID0gTW9kYWxGb290ZXI7XG5tb2R1bGUuZXhwb3J0cy5IZWFkaW5nICA9IE1vZGFsSGVhZGluZztcblxuXG5cbi8vIFdFQlBBQ0sgRk9PVEVSIC8vXG4vLyAuL3NyYy9Nb2RhbC5qcyJdLCJzb3VyY2VSb290IjoiIn0=