'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('react');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Alert = require('../src/Alert');
var Icon = require('../src/Icon');

var SCOPE = { React: React, Alert: Alert, Icon: Icon };

var EXAMPLE_DEFAULT = '<Alert.Info>Flash message goes here.</Alert.Info>';
var EXAMPLE_DANGER = '<Alert.Danger>\n    <Icon id="alert" size="sm" /> This is an alert!\n</Alert.Danger>';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Alerts', active: 'alerts' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Alerts' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(
                    'p',
                    null,
                    'Flash messages, or alerts, inform users of successful or pending actions. Use them sparingly. Don\u2019t show more than one at a time.'
                ),
                React.createElement(CodeEditor, { source: 'const Alert = require(\'gitbook-styleguide/lib/Alert\');' })
            )
        ),
        React.createElement(Example, { title: 'Default', source: EXAMPLE_DEFAULT, scope: SCOPE }),
        React.createElement(Example, { title: 'Danger', source: EXAMPLE_DANGER, scope: SCOPE })
    );
};
//# sourceMappingURL=data:application/json;base64,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