'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('react');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Avatar = require('../src/Avatar');
var AvatarsStack = require('../src/AvatarsStack');

var SCOPE = { React: React, Avatar: Avatar, AvatarsStack: AvatarsStack };

var EXAMPLE_IMPORT = 'const Avatar = require(\'gitbook-styleguide/lib/Avatar\');\nconst AvatarsStack = require(\'gitbook-styleguide/lib/AvatarsStack\');';

var EXAMPLE_DEFAULT = '<Avatar\n    src="https://picturepan2.github.io/spectre/demo/img/avatar-1.png"\n    size="lg"\n    />\n<Avatar\n    src="https://picturepan2.github.io/spectre/demo/img/avatar-3.png"\n    size="md"\n    />\n<Avatar\n    src="https://picturepan2.github.io/spectre/demo/img/avatar-4.png"\n    size="sm"\n    />';

var EXAMPLE_STACK = '<AvatarsStack>\n    <AvatarsStack.Item>\n        <Avatar\n            src="https://picturepan2.github.io/spectre/demo/img/avatar-1.png"\n            size="sm"\n            />\n    </AvatarsStack.Item>\n    <AvatarsStack.Item>\n        <Avatar\n            src="https://picturepan2.github.io/spectre/demo/img/avatar-3.png"\n            size="sm"\n            />\n    </AvatarsStack.Item>\n    <AvatarsStack.Item>\n        <Avatar\n            src="https://picturepan2.github.io/spectre/demo/img/avatar-4.png"\n            size="sm"\n            />\n    </AvatarsStack.Item>\n</AvatarsStack>';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Avatars', active: 'avatars' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Avatars' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement('p', null),
                React.createElement(CodeEditor, { source: EXAMPLE_IMPORT })
            )
        ),
        React.createElement(Example, { title: 'Layout', source: EXAMPLE_DEFAULT, scope: SCOPE }),
        React.createElement(
            Example,
            { title: 'Stack', source: EXAMPLE_STACK, scope: SCOPE },
            'Stack of avatars can be used to display a list of participants.'
        )
    );
};
//# sourceMappingURL=data:application/json;base64,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