'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('react');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Dropdown = require('../src/Dropdown');
var Button = require('../src/Button');
var Icon = require('../src/Icon');

var SCOPE = { React: React, Dropdown: Dropdown, Button: Button, Icon: Icon };

var EXAMPLE_IMPORT = 'const Dropdown = require(\'gitbook-styleguide/lib/Dropdown\')';
var EXAMPLE_DEFAULT = '<Dropdown>\n    <Button>\n        Toggle dropdown <Button.Caret />\n    </Button>\n    <Dropdown.Item header>Account</Dropdown.Item>\n    <Dropdown.Item href="/profile">Profile</Dropdown.Item>\n    <Dropdown.Item href="/settings">Settings</Dropdown.Item>\n    <Dropdown.Divider />\n    <Dropdown.Item onClick={e => alert(\'Logout\')}>Logout</Dropdown.Item>\n</Dropdown>';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Dropdowns', active: 'dropdowns' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Dropdowns' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(CodeEditor, { source: EXAMPLE_IMPORT })
            )
        ),
        React.createElement(Example, { title: 'Default', source: EXAMPLE_DEFAULT, scope: SCOPE })
    );
};
//# sourceMappingURL=data:application/json;base64,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