'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('react');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Table = require('../src/Table');
var ListGroup = require('../src/ListGroup');

var SCOPE = { React: React, Panel: Panel, Table: Table, ListGroup: ListGroup };

var EXAMPLE_IMPORT = 'const Panel = require(\'gitbook-styleguide/lib/Panel\');';

var EXAMPLE_DEFAULT = '<Panel>\n    <Panel.Heading title="Title" />\n    <Panel.Body>\n        Body of the panel\n    </Panel.Body>\n</Panel>';

var EXAMPLE_STYLES = '<Panel style="danger">\n    <Panel.Heading title="Title" />\n    <Panel.Body>\n        Body of the panel\n    </Panel.Body>\n</Panel>';

var EXAMPLE_LISTGROUP = '<Panel>\n    <Panel.Heading title="Title" />\n    <ListGroup>\n        <ListGroup.Item active={true}>Account</ListGroup.Item>\n        <ListGroup.Item>Profile</ListGroup.Item>\n        <ListGroup.Item>Notifications</ListGroup.Item>\n    </ListGroup>\n</Panel>';

var EXAMPLE_TABLE = '<Panel>\n    <Panel.Heading title="Title" />\n    <Table>\n        <thead>\n            <tr>\n                <th>Title</th>\n                <th>Updated</th>\n            </tr>\n        </thead>\n        <tbody>\n            <tr>\n                <td>PHP</td>\n                <td>1 month ago</td>\n            </tr>\n            <tr>\n                <td>JS</td>\n                <td>1 month ago</td>\n            </tr>\n        </tbody>\n    </Table>\n</Panel>';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Panels', active: 'panels' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Panel' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement('p', null),
                React.createElement(CodeEditor, { source: EXAMPLE_IMPORT })
            )
        ),
        React.createElement(Example, { title: 'Example', source: EXAMPLE_DEFAULT, scope: SCOPE }),
        React.createElement(Example, { title: 'Styles', source: EXAMPLE_STYLES, scope: SCOPE }),
        React.createElement(Example, { title: 'With a table', source: EXAMPLE_TABLE, scope: SCOPE }),
        React.createElement(Example, { title: 'With a list group', source: EXAMPLE_LISTGROUP, scope: SCOPE })
    );
};
//# sourceMappingURL=data:application/json;base64,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