'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('react');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Tooltip = require('../src/Tooltip');
var Button = require('../src/Button');

var SCOPE = { React: React, Tooltip: Tooltip, Button: Button };

var EXAMPLE_IMPORT = 'const Tooltip = require(\'gitbook-styleguide/lib/Tooltip\');';

var EXAMPLE_DEFAULT = '<Tooltip title="Hello World">\n     There is a tooltip\n</Tooltip>\n<Tooltip title="Hello World">\n     , hover this text.\n</Tooltip>\n<Tooltip title="Hello World" open>\n     This one is open\n</Tooltip>';

var EXAMPLE_POSITIONS = '<Tooltip title="Bottom right" open position={Tooltip.POSITIONS.BOTTOM_RIGHT}>\n    <code>Bottom right</code>\n</Tooltip>\n<Tooltip title="Top right" open position={Tooltip.POSITIONS.TOP_RIGHT}>\n    <code>Top right</code>\n</Tooltip>\n<Tooltip title="Bottom" open position={Tooltip.POSITIONS.BOTTOM}>\n    <code>Bottom</code>\n</Tooltip>\n<Tooltip title="Bottom left" open position={Tooltip.POSITIONS.BOTTOM_LEFT}>\n    <code>Bottom left</code>\n</Tooltip>\n<Tooltip title="Top" open position={Tooltip.POSITIONS.TOP}>\n    <code>Top</code>\n</Tooltip>';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Tooltips', active: 'tooltips' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Tooltips' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(CodeEditor, { source: EXAMPLE_IMPORT })
            )
        ),
        React.createElement(Example, { title: 'Example', source: EXAMPLE_DEFAULT, scope: SCOPE }),
        React.createElement(Example, { title: 'Positions', source: EXAMPLE_POSITIONS, scope: SCOPE })
    );
};
//# sourceMappingURL=data:application/json;base64,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