'use strict';

var React = require('react');
var classNames = require('classnames');

var Icon = require('./Icon');

/**
 * Blankslate represent an emptycontent
 *
 * <Blankslate icon="book">
 *      <h3>No books</h3>
 *      <p>Create a book to get started</p>
 * </Blankslate>
 */

var Blankslate = React.createClass({
    displayName: 'Blankslate',

    propTypes: {
        icon: React.PropTypes.string,
        background: React.PropTypes.bool,
        full: React.PropTypes.bool,
        children: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            background: false,
            full: true
        };
    },
    render: function render() {
        var inner = void 0;
        var icon = this.props.icon;
        var className = classNames('blankslate', {
            'with-background': this.props.background,
            'full-width': this.props.full
        });

        if (icon) {
            inner = React.createElement(
                BlankslateIcon,
                null,
                React.createElement(Icon, { id: icon })
            );
        }

        return React.createElement(
            'div',
            { className: className },
            inner,
            this.props.children
        );
    }
});

var BlankslateIcon = React.createClass({
    displayName: 'BlankslateIcon',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'icon' },
            this.props.children
        );
    }
});

/*
 * A full space layout with a blanksate
 */
var BlankslateLayout = React.createClass({
    displayName: 'BlankslateLayout',

    propTypes: {
        background: React.PropTypes.bool,
        children: React.PropTypes.node
    },

    render: function render() {
        var _props = this.props,
            children = _props.children,
            background = _props.background;

        var className = classNames('blankslate-layout', {
            'with-background': background
        });

        return React.createElement(
            'div',
            { className: className },
            children
        );
    }
});

module.exports = Blankslate;
module.exports.Layout = BlankslateLayout;
module.exports.Icon = BlankslateIcon;
//# sourceMappingURL=data:application/json;base64,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