'use strict';

var React = require('react');
var classNames = require('classnames');

var FilterItem = React.createClass({
    displayName: 'FilterItem',

    propTypes: {
        children: React.PropTypes.node,
        selected: React.PropTypes.bool,
        href: React.PropTypes.string,
        className: React.PropTypes.string,
        count: React.PropTypes.number,
        onClick: React.PropTypes.func
    },

    getDefaultProps: function getDefaultProps() {
        return {
            selected: false,
            href: '#'
        };
    },
    onClick: function onClick(e) {
        if (!this.props.onClick) {
            return;
        }

        e.preventDefault();
        this.props.onClick();
    },
    render: function render() {
        var className = classNames('filter-item', this.props.className, {
            selected: this.props.selected
        });
        var count = this.props.count;
        var href = this.props.href;
        var inner = '';

        if (typeof count !== 'undefined') {
            inner = React.createElement(
                'span',
                { className: 'count' },
                count
            );
        }

        return React.createElement(
            'li',
            null,
            React.createElement(
                'a',
                { className: className, href: href, onClick: this.onClick },
                inner,
                this.props.children
            )
        );
    }
});

var FilterList = React.createClass({
    displayName: 'FilterList',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'ul',
            { className: 'filter-list' },
            this.props.children
        );
    }
});

module.exports = FilterList;
module.exports.Item = FilterItem;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNyYy9GaWx0ZXJMaXN0LmpzIl0sIm5hbWVzIjpbIlJlYWN0IiwicmVxdWlyZSIsImNsYXNzTmFtZXMiLCJGaWx0ZXJJdGVtIiwiY3JlYXRlQ2xhc3MiLCJwcm9wVHlwZXMiLCJjaGlsZHJlbiIsIlByb3BUeXBlcyIsIm5vZGUiLCJzZWxlY3RlZCIsImJvb2wiLCJocmVmIiwic3RyaW5nIiwiY2xhc3NOYW1lIiwiY291bnQiLCJudW1iZXIiLCJvbkNsaWNrIiwiZnVuYyIsImdldERlZmF1bHRQcm9wcyIsImUiLCJwcm9wcyIsInByZXZlbnREZWZhdWx0IiwicmVuZGVyIiwiaW5uZXIiLCJGaWx0ZXJMaXN0IiwibW9kdWxlIiwiZXhwb3J0cyIsIkl0ZW0iXSwibWFwcGluZ3MiOiI7O0FBQUEsSUFBTUEsUUFBUUMsUUFBUSxPQUFSLENBQWQ7QUFDQSxJQUFNQyxhQUFhRCxRQUFRLFlBQVIsQ0FBbkI7O0FBRUEsSUFBTUUsYUFBYUgsTUFBTUksV0FBTixDQUFrQjtBQUFBOztBQUNqQ0MsZUFBVztBQUNQQyxrQkFBVU4sTUFBTU8sU0FBTixDQUFnQkMsSUFEbkI7QUFFUEMsa0JBQVdULE1BQU1PLFNBQU4sQ0FBZ0JHLElBRnBCO0FBR1BDLGNBQVdYLE1BQU1PLFNBQU4sQ0FBZ0JLLE1BSHBCO0FBSVBDLG1CQUFXYixNQUFNTyxTQUFOLENBQWdCSyxNQUpwQjtBQUtQRSxlQUFXZCxNQUFNTyxTQUFOLENBQWdCUSxNQUxwQjtBQU1QQyxpQkFBV2hCLE1BQU1PLFNBQU4sQ0FBZ0JVO0FBTnBCLEtBRHNCOztBQVVqQ0MsbUJBVmlDLDZCQVVmO0FBQ2QsZUFBTztBQUNIVCxzQkFBVSxLQURQO0FBRUhFLGtCQUFRO0FBRkwsU0FBUDtBQUlILEtBZmdDO0FBaUJqQ0ssV0FqQmlDLG1CQWlCekJHLENBakJ5QixFQWlCdEI7QUFDUCxZQUFJLENBQUMsS0FBS0MsS0FBTCxDQUFXSixPQUFoQixFQUF5QjtBQUNyQjtBQUNIOztBQUVERyxVQUFFRSxjQUFGO0FBQ0EsYUFBS0QsS0FBTCxDQUFXSixPQUFYO0FBQ0gsS0F4QmdDO0FBMEJqQ00sVUExQmlDLG9CQTBCeEI7QUFDTCxZQUFNVCxZQUFZWCxXQUFXLGFBQVgsRUFBMEIsS0FBS2tCLEtBQUwsQ0FBV1AsU0FBckMsRUFBZ0Q7QUFDOURKLHNCQUFVLEtBQUtXLEtBQUwsQ0FBV1g7QUFEeUMsU0FBaEQsQ0FBbEI7QUFHQSxZQUFNSyxRQUFRLEtBQUtNLEtBQUwsQ0FBV04sS0FBekI7QUFDQSxZQUFNSCxPQUFRLEtBQUtTLEtBQUwsQ0FBV1QsSUFBekI7QUFDQSxZQUFJWSxRQUFRLEVBQVo7O0FBRUEsWUFBSSxPQUFPVCxLQUFQLEtBQWlCLFdBQXJCLEVBQWtDO0FBQzlCUyxvQkFBUTtBQUFBO0FBQUEsa0JBQU0sV0FBVSxPQUFoQjtBQUF5QlQ7QUFBekIsYUFBUjtBQUNIOztBQUVELGVBQ0k7QUFBQTtBQUFBO0FBQ0k7QUFBQTtBQUFBLGtCQUFHLFdBQVdELFNBQWQsRUFBeUIsTUFBTUYsSUFBL0IsRUFBcUMsU0FBUyxLQUFLSyxPQUFuRDtBQUNLTyxxQkFETDtBQUVLLHFCQUFLSCxLQUFMLENBQVdkO0FBRmhCO0FBREosU0FESjtBQVFIO0FBOUNnQyxDQUFsQixDQUFuQjs7QUFpREEsSUFBTWtCLGFBQWF4QixNQUFNSSxXQUFOLENBQWtCO0FBQUE7O0FBQ2pDQyxlQUFXO0FBQ1BDLGtCQUFVTixNQUFNTyxTQUFOLENBQWdCQztBQURuQixLQURzQjs7QUFLakNjLFVBTGlDLG9CQUt4QjtBQUNMLGVBQ0k7QUFBQTtBQUFBLGNBQUksV0FBVSxhQUFkO0FBQ0ssaUJBQUtGLEtBQUwsQ0FBV2Q7QUFEaEIsU0FESjtBQUtIO0FBWGdDLENBQWxCLENBQW5COztBQWNBbUIsT0FBT0MsT0FBUCxHQUFpQkYsVUFBakI7QUFDQUMsT0FBT0MsT0FBUCxDQUFlQyxJQUFmLEdBQXNCeEIsVUFBdEIiLCJmaWxlIjoiRmlsdGVyTGlzdC5qcyIsInNvdXJjZVJvb3QiOiIvVXNlcnMvbmljb2xhcy9Qcm9nL0dpdEJvb2svc3R5bGVndWlkZSIsInNvdXJjZXNDb250ZW50IjpbImNvbnN0IFJlYWN0ID0gcmVxdWlyZSgncmVhY3QnKTtcbmNvbnN0IGNsYXNzTmFtZXMgPSByZXF1aXJlKCdjbGFzc25hbWVzJyk7XG5cbmNvbnN0IEZpbHRlckl0ZW0gPSBSZWFjdC5jcmVhdGVDbGFzcyh7XG4gICAgcHJvcFR5cGVzOiB7XG4gICAgICAgIGNoaWxkcmVuOiBSZWFjdC5Qcm9wVHlwZXMubm9kZSxcbiAgICAgICAgc2VsZWN0ZWQ6ICBSZWFjdC5Qcm9wVHlwZXMuYm9vbCxcbiAgICAgICAgaHJlZjogICAgICBSZWFjdC5Qcm9wVHlwZXMuc3RyaW5nLFxuICAgICAgICBjbGFzc05hbWU6IFJlYWN0LlByb3BUeXBlcy5zdHJpbmcsXG4gICAgICAgIGNvdW50OiAgICAgUmVhY3QuUHJvcFR5cGVzLm51bWJlcixcbiAgICAgICAgb25DbGljazogICBSZWFjdC5Qcm9wVHlwZXMuZnVuY1xuICAgIH0sXG5cbiAgICBnZXREZWZhdWx0UHJvcHMoKSB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBzZWxlY3RlZDogZmFsc2UsXG4gICAgICAgICAgICBocmVmOiAgICcjJ1xuICAgICAgICB9O1xuICAgIH0sXG5cbiAgICBvbkNsaWNrKGUpIHtcbiAgICAgICAgaWYgKCF0aGlzLnByb3BzLm9uQ2xpY2spIHtcbiAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgfVxuXG4gICAgICAgIGUucHJldmVudERlZmF1bHQoKTtcbiAgICAgICAgdGhpcy5wcm9wcy5vbkNsaWNrKCk7XG4gICAgfSxcblxuICAgIHJlbmRlcigpIHtcbiAgICAgICAgY29uc3QgY2xhc3NOYW1lID0gY2xhc3NOYW1lcygnZmlsdGVyLWl0ZW0nLCB0aGlzLnByb3BzLmNsYXNzTmFtZSwge1xuICAgICAgICAgICAgc2VsZWN0ZWQ6IHRoaXMucHJvcHMuc2VsZWN0ZWRcbiAgICAgICAgfSk7XG4gICAgICAgIGNvbnN0IGNvdW50ID0gdGhpcy5wcm9wcy5jb3VudDtcbiAgICAgICAgY29uc3QgaHJlZiAgPSB0aGlzLnByb3BzLmhyZWY7XG4gICAgICAgIGxldCBpbm5lciA9ICcnO1xuXG4gICAgICAgIGlmICh0eXBlb2YgY291bnQgIT09ICd1bmRlZmluZWQnKSB7XG4gICAgICAgICAgICBpbm5lciA9IDxzcGFuIGNsYXNzTmFtZT1cImNvdW50XCI+e2NvdW50fTwvc3Bhbj47XG4gICAgICAgIH1cblxuICAgICAgICByZXR1cm4gKFxuICAgICAgICAgICAgPGxpPlxuICAgICAgICAgICAgICAgIDxhIGNsYXNzTmFtZT17Y2xhc3NOYW1lfSBocmVmPXtocmVmfSBvbkNsaWNrPXt0aGlzLm9uQ2xpY2t9PlxuICAgICAgICAgICAgICAgICAgICB7aW5uZXJ9XG4gICAgICAgICAgICAgICAgICAgIHt0aGlzLnByb3BzLmNoaWxkcmVufVxuICAgICAgICAgICAgICAgIDwvYT5cbiAgICAgICAgICAgIDwvbGk+XG4gICAgICAgICk7XG4gICAgfVxufSk7XG5cbmNvbnN0IEZpbHRlckxpc3QgPSBSZWFjdC5jcmVhdGVDbGFzcyh7XG4gICAgcHJvcFR5cGVzOiB7XG4gICAgICAgIGNoaWxkcmVuOiBSZWFjdC5Qcm9wVHlwZXMubm9kZVxuICAgIH0sXG5cbiAgICByZW5kZXIoKSB7XG4gICAgICAgIHJldHVybiAoXG4gICAgICAgICAgICA8dWwgY2xhc3NOYW1lPVwiZmlsdGVyLWxpc3RcIj5cbiAgICAgICAgICAgICAgICB7dGhpcy5wcm9wcy5jaGlsZHJlbn1cbiAgICAgICAgICAgIDwvdWw+XG4gICAgICAgICk7XG4gICAgfVxufSk7XG5cbm1vZHVsZS5leHBvcnRzID0gRmlsdGVyTGlzdDtcbm1vZHVsZS5leHBvcnRzLkl0ZW0gPSBGaWx0ZXJJdGVtO1xuIl19