'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var React = require('react');
var classNames = require('classnames');

/**
 * Main container for a form
 * @type {ReactClass}
 */
var Form = React.createClass({
    displayName: 'Form',

    propTypes: {
        children: React.PropTypes.node
    },

    submit: function submit() {
        this.refs.form.submit();
    },
    render: function render() {
        return React.createElement(
            'form',
            _extends({ ref: 'form' }, this.props),
            this.props.children
        );
    }
});

/**
 * Container for an input, its label and help text.
 * @type {ReactClass}
 */
var FormGroup = React.createClass({
    displayName: 'FormGroup',

    propTypes: {
        error: React.PropTypes.bool,
        className: React.PropTypes.string,
        children: React.PropTypes.node
    },

    getDefaulProps: function getDefaulProps() {
        return {
            error: false
        };
    },
    render: function render() {
        var className = classNames('form-group', {
            'has-error': this.props.error
        }, this.props.className);

        return React.createElement(
            'div',
            { className: className },
            this.props.children
        );
    }
});

/**
 * An help text for an input
 * @type {ReactClass}
 */
var FormHelpBlock = React.createClass({
    displayName: 'FormHelpBlock',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'p',
            { className: 'help-block' },
            this.props.children
        );
    }
});

/**
 * Container for submit/cancel actions
 * @type {ReactClass}
 */
var FormActions = React.createClass({
    displayName: 'FormActions',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'form-actions' },
            this.props.children
        );
    }
});

module.exports = Form;
module.exports.Actions = FormActions;
module.exports.Group = FormGroup;
module.exports.HelpBlock = FormHelpBlock;
//# sourceMappingURL=data:application/json;base64,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