'use strict';

var React = require('react');
var classNames = require('classnames');
var Icon = require('./Icon');

/**
 * Component to create overviews/intros with a title, description,
 * metas info (links), and a picture.
 */
var Overview = React.createClass({
    displayName: 'Overview',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'overview' },
            this.props.children
        );
    }
});

Overview.Title = React.createClass({
    displayName: 'Title',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'h1',
            { className: 'overview-title' },
            this.props.children
        );
    }
});

Overview.StepTitle = React.createClass({
    displayName: 'StepTitle',

    propTypes: {
        children: React.PropTypes.node,
        primary: React.PropTypes.bool,
        href: React.PropTypes.string
    },

    render: function render() {
        var _props = this.props,
            children = _props.children,
            primary = _props.primary,
            href = _props.href;

        var className = classNames('overview-steptitle', {
            primary: primary
        });

        if (href) {
            return React.createElement(
                'a',
                { href: href, className: className },
                children
            );
        }

        return React.createElement(
            'div',
            { className: className },
            children
        );
    }
});

Overview.StepDivider = React.createClass({
    displayName: 'StepDivider',
    render: function render() {
        return React.createElement(
            'div',
            { className: 'overview-stepdivider' },
            React.createElement(Icon, { id: 'chevron-right' })
        );
    }
});

Overview.Note = React.createClass({
    displayName: 'Note',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'p',
            { className: 'overview-note' },
            this.props.children
        );
    }
});

Overview.Description = React.createClass({
    displayName: 'Description',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'p',
            { className: 'overview-description' },
            this.props.children
        );
    }
});

Overview.Meta = React.createClass({
    displayName: 'Meta',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'overview-meta' },
            this.props.children
        );
    }
});

module.exports = Overview;
//# sourceMappingURL=data:application/json;base64,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