'use strict';

var React = require('react');
var classNames = require('classnames');

var SIZES = require('./SIZES');

var Textarea = React.createClass({
    displayName: 'Textarea',

    propTypes: {
        onChange: React.PropTypes.func,
        name: React.PropTypes.string,
        className: React.PropTypes.string,
        placeholder: React.PropTypes.string,
        disabled: React.PropTypes.bool,
        autoFocus: React.PropTypes.bool,
        size: React.PropTypes.oneOf(SIZES),
        rows: React.PropTypes.number,
        maxLength: React.PropTypes.number,
        defaultValue: React.PropTypes.string,
        value: React.PropTypes.oneOfType([React.PropTypes.string, React.PropTypes.bool])
    },

    /*
        APIs for parent component
     */
    focus: function focus() {
        this.refs.textarea.focus();
    },
    blur: function blur() {
        this.refs.textarea.blur();
    },
    getDefaultProps: function getDefaultProps() {
        return {
            size: SIZES[0],
            rows: 3
        };
    },
    onChange: function onChange(e) {
        if (this.props.onChange) {
            this.props.onChange(e);
        }
    },
    render: function render() {
        var _props = this.props,
            disabled = _props.disabled,
            name = _props.name,
            placeholder = _props.placeholder,
            size = _props.size,
            rows = _props.rows,
            autoFocus = _props.autoFocus,
            value = _props.value,
            defaultValue = _props.defaultValue,
            maxLength = _props.maxLength;


        var className = classNames('form-control', 'input-' + size, this.props.className);

        return React.createElement('textarea', { ref: 'textarea',
            className: className, rows: rows, maxLength: maxLength,
            autoFocus: autoFocus, disabled: disabled,
            name: name, value: value, defaultValue: defaultValue,
            placeholder: placeholder, onChange: this.onChange });
    }
});

module.exports = Textarea;
//# sourceMappingURL=data:application/json;base64,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