'use strict';

var React = require('react');

/**
 * Backdrop for modals, dropdown, popover.
 *
 *
 * For example:
 *
 * <Backdrop onClose={onClosePopover}>
 *      <Popover>...</Popover>
 * </Backdrop>
 */
var Backdrop = React.createClass({
    displayName: 'Backdrop',

    propTypes: {
        // Close on escape
        escape: React.PropTypes.bool,
        // Z-index for the backdrop
        zIndex: React.PropTypes.number,
        // Callback when backdrop is closed
        onClose: React.PropTypes.func.isRequired,
        children: React.PropTypes.node.isRequired,
        wrapper: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            escape: true,
            zIndex: 200,
            wrapper: React.createElement('div', null)
        };
    },
    onClose: function onClose() {
        var onClose = this.props.onClose;

        onClose();
    },
    onClick: function onClick(event) {
        event.stopPropagation();
        event.preventDefault();
        this.onClose();
    },
    onKeyDown: function onKeyDown(event) {
        var escape = this.props.escape;


        if (event.keyCode === 27 && escape) {
            this.onClose();
        }
    },
    componentDidMount: function componentDidMount() {
        window.addEventListener('keydown', this.onKeyDown);
    },
    componentWillUnmount: function componentWillUnmount() {
        window.removeEventListener('keydown', this.onKeyDown);
    },
    render: function render() {
        var _props = this.props,
            zIndex = _props.zIndex,
            wrapper = _props.wrapper,
            children = _props.children;

        var style = {
            zIndex: zIndex,
            position: 'fixed',
            top: 0,
            right: 0,
            width: '100%',
            height: '100%'
        };

        return React.cloneElement(wrapper, {}, React.createElement('div', { className: 'Backdrop', style: style, onClick: this.onClick }), wrapper.props.children, children);
    }
});

module.exports = Backdrop;
//# sourceMappingURL=data:application/json;base64,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