'use strict';

var React = require('react');

var HTMLPage = React.createClass({
    displayName: 'HTMLPage',

    propTypes: {
        lang: React.PropTypes.string,
        children: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            lang: 'en'
        };
    },
    render: function render() {
        return React.createElement(
            'html',
            { lang: this.props.lang },
            this.props.children
        );
    }
});

var HTMLHead = React.createClass({
    displayName: 'HTMLHead',

    propTypes: {
        charSet: React.PropTypes.string,
        children: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            charSet: 'utf-8'
        };
    },
    render: function render() {
        return React.createElement(
            'head',
            null,
            React.createElement('meta', { charSet: this.props.charSet }),
            this.props.children
        );
    }
});

var HTMLBody = React.createClass({
    displayName: 'HTMLBody',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'body',
            null,
            this.props.children
        );
    }
});

module.exports = HTMLPage;
module.exports.Head = HTMLHead;
module.exports.Body = HTMLBody;
//# sourceMappingURL=data:application/json;base64,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