'use strict';

var React = require('react');
var classNames = require('classnames');
var Icon = require('./Icon');

var Tags = React.createClass({
    displayName: 'Tags',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'ul',
            { className: 'tags' },
            this.props.children
        );
    }
});

var TagItem = React.createClass({
    displayName: 'TagItem',

    propTypes: {
        title: React.PropTypes.string,
        href: React.PropTypes.string,
        active: React.PropTypes.bool,
        onClick: React.PropTypes.func,
        // count and showX are exclusive
        count: React.PropTypes.number,
        showX: React.PropTypes.bool
    },

    getDefaultProps: function getDefaultProps() {
        return {
            href: '#',
            showX: false
        };
    },
    onClick: function onClick(e) {
        var onClick = this.props.onClick;


        if (!onClick) {
            return;
        }

        e.preventDefault();
        onClick();
    },
    render: function render() {
        var _props = this.props,
            active = _props.active,
            count = _props.count,
            showX = _props.showX,
            title = _props.title,
            href = _props.href;


        var className = classNames('tag', {
            active: active
        });

        var inner = '';
        if (showX) {
            inner = React.createElement(
                'span',
                { className: 'extra' },
                ' ',
                React.createElement(Icon, { id: 'x' })
            );
        } else if (typeof count !== 'undefined') {
            inner = React.createElement(
                'span',
                { className: 'extra' },
                ' | ',
                count
            );
        }

        return React.createElement(
            'li',
            { className: className },
            React.createElement(
                'a',
                { href: href, onClick: this.onClick },
                React.createElement(
                    'span',
                    { className: 'name' },
                    title
                ),
                inner
            )
        );
    }
});

module.exports = Tags;
module.exports.Item = TagItem;
//# sourceMappingURL=data:application/json;base64,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