'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('react');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Link = require('../src/Link');

var SCOPE = { React: React, Link: Link };

var EXAMPLE_DEFAULT = '\n<ul>\n    <li>\n        <Link href="https://www.gitbook.com" target="_blank">Normal link</Link>\n    </li>\n    <li>\n        <Link muted={true}>Muted link</Link>\n    </li>\n\n    <li>\n        <Link underlined={true}>Underlined link</Link>\n    </li>\n\n    <li>\n        <Link onClick={() => window.alert(\'onClick\')}>onClick link</Link>\n    </li>\n</ul>\n';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Links', active: 'links' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Links' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(
                    'p',
                    null,
                    'Some links'
                ),
                React.createElement(CodeEditor, { source: 'const Link = require(\'gitbook-styleguide/lib/Link\');' })
            )
        ),
        React.createElement(Example, { title: 'Default', source: EXAMPLE_DEFAULT, scope: SCOPE })
    );
};
//# sourceMappingURL=data:application/json;base64,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