'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var React = require('react');
var classNames = require('classnames');

var Icon = require('./Icon');
var Container = require('./Container');
var STYLES = require('./STYLES');

var Alert = React.createClass({
    displayName: 'Alert',

    propTypes: {
        onClose: React.PropTypes.func,
        closable: React.PropTypes.bool,
        style: React.PropTypes.oneOf(STYLES),
        children: React.PropTypes.node,
        className: React.PropTypes.string
    },

    getInitialState: function getInitialState() {
        return {
            opened: true
        };
    },
    getDefaultProps: function getDefaultProps() {
        return {
            onClose: undefined,
            closable: false,
            style: STYLES[0]
        };
    },
    onClose: function onClose(e) {
        e.preventDefault();
        var onClose = this.props.onClose;

        this.setState({
            opened: false
        }, function () {
            if (onClose) onClose();
        });
    },
    render: function render() {
        var style = this.props.style;
        var className = classNames('alert', 'alert-' + style, this.props.className);
        var onClose = this.props.onClose;
        var closable = this.props.closable;
        var inner = void 0;

        if (!this.state.opened) {
            return React.createElement('div', null);
        }

        if (onClose || closable) {
            inner = React.createElement(
                'a',
                { href: '#', onClick: this.onClose, className: 'alert-btn' },
                React.createElement(Icon, { id: 'x' })
            );
        }

        return React.createElement(
            'div',
            { className: className },
            React.createElement(
                Container,
                { fluid: true },
                inner,
                this.props.children
            )
        );
    }
});

var AlertButton = React.createClass({
    displayName: 'AlertButton',

    propTypes: {
        children: React.PropTypes.node,
        className: React.PropTypes.string,
        href: React.PropTypes.string,
        onClick: React.PropTypes.func
    },

    onClick: function onClick(e) {
        if (this.props.onClick) {
            e.preventDefault();
            this.props.onClick();
        }
    },
    render: function render() {
        var _props = this.props,
            href = _props.href,
            className = _props.className;

        className = classNames('alert-btn', className || '');
        href = href || '#';

        return React.createElement(
            'a',
            { className: className, href: href, onClick: this.onClick },
            this.props.children
        );
    }
});

/**
 * Create a style of alert
 * @param {String} style
 * @return {React.Component}
 */
function createAlertStyle(style) {
    return React.createClass({
        displayName: Alert.displayName + style,
        render: function render() {
            return React.createElement(Alert, _extends({}, this.props, { style: style.toLowerCase() }));
        }
    });
}

module.exports = Alert;
module.exports.Button = AlertButton;
module.exports.Info = createAlertStyle('Info');
module.exports.Danger = createAlertStyle('Danger');
module.exports.Success = createAlertStyle('Success');
module.exports.Warning = createAlertStyle('Warning');
//# sourceMappingURL=data:application/json;base64,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