'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var React = require('react');
var classNames = require('classnames');

/**
 * Title (text) of the card
 * @type {ReactClass}
 */
var CardTitle = React.createClass({
    displayName: 'CardTitle',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        var children = this.props.children;


        return React.createElement(
            'h2',
            { className: 'CardTitle' },
            children
        );
    }
});

/**
 * Small icon to indicate a type/flag on the card.
 * @type {ReactClass}
 */
var CardFlag = React.createClass({
    displayName: 'CardFlag',

    propTypes: {
        children: React.PropTypes.node,
        style: React.PropTypes.string
    },

    render: function render() {
        var _props = this.props,
            children = _props.children,
            style = _props.style;

        var className = classNames('CardFlag', 'style-' + style);

        return React.createElement(
            'span',
            { className: className },
            children
        );
    }
});

/**
 * Container for the title of the card.
 * @type {ReactClass}
 */
var CardHeading = React.createClass({
    displayName: 'CardHeading',

    propTypes: {
        children: React.PropTypes.node,
        title: React.PropTypes.string
    },

    render: function render() {
        var _props2 = this.props,
            children = _props2.children,
            title = _props2.title;


        if (title) {
            children = React.createElement(
                CardTitle,
                null,
                title
            );
        }

        return React.createElement(
            'div',
            { className: 'CardHeading' },
            children
        );
    }
});

/**
 * Container for the inner text and description of the card.
 * @type {ReactClass}
 */
var CardBody = React.createClass({
    displayName: 'CardBody',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        var children = this.props.children;


        return React.createElement(
            'div',
            { className: 'CardBody' },
            children
        );
    }
});

/**
 * Container for the actions of the card.
 * It prevent the propagation of clicks to the card itself.
 *
 * @type {ReactClass}
 */
var CardActions = React.createClass({
    displayName: 'CardActions',

    propTypes: {
        children: React.PropTypes.node
    },

    onClick: function onClick(event) {
        event.stopPropagation();
    },
    render: function render() {
        var children = this.props.children;


        return React.createElement(
            'div',
            { className: 'CardActions', onClick: this.onClick },
            children
        );
    }
});

/**
 * Container for the card.
 * @type {ReactClass}
 */
var Card = React.createClass({
    displayName: 'Card',

    propTypes: {
        children: React.PropTypes.node,
        href: React.PropTypes.string,
        onClick: React.PropTypes.func
    },
    statics: {
        Body: CardBody,
        Heading: CardHeading,
        Title: CardTitle,
        Actions: CardActions,
        Flag: CardFlag
    },

    onClick: function onClick(event) {
        var _props3 = this.props,
            onClick = _props3.onClick,
            href = _props3.href;


        if (href) {
            event.stopPropagation();
            event.preventDefault();

            window.location.href = href;
        } else {
            onClick(event);
        }
    },
    render: function render() {
        var _props4 = this.props,
            children = _props4.children,
            onClick = _props4.onClick,
            href = _props4.href,
            props = _objectWithoutProperties(_props4, ['children', 'onClick', 'href']); // eslint-disable-line no-unused-vars

        return React.createElement(
            'div',
            _extends({}, props, { className: 'Card', onClick: this.onClick }),
            children
        );
    }
});

module.exports = Card;
//# sourceMappingURL=data:application/json;base64,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