'use strict';

var IS_DEV = require('./is-dev');

/**
 * Log a development warning.
 * @param {String} message
 */

module.exports = function warning(message) {
    if (!IS_DEV) {
        return;
    }

    if (typeof console !== 'undefined') {
        var _console;

        for (var _len = arguments.length, more = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
            more[_key - 1] = arguments[_key];
        }

        (_console = console).error.apply(_console, ['Warning: ' + message].concat(more)); // eslint-disable-line no-console
    }

    try {
        // --- Welcome to debugging Slate ---
        // This error was thrown as a convenience so that you can use this stack
        // to find the callsite that caused this warning to fire.
        throw new Error(message);
    } catch (x) {
        // This error is only for debugging
    }
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy91dGlscy93YXJuaW5nLmpzIl0sIm5hbWVzIjpbIklTX0RFViIsInJlcXVpcmUiLCJtb2R1bGUiLCJleHBvcnRzIiwid2FybmluZyIsIm1lc3NhZ2UiLCJjb25zb2xlIiwibW9yZSIsImVycm9yIiwiRXJyb3IiLCJ4Il0sIm1hcHBpbmdzIjoiOztBQUFBLElBQU1BLFNBQVNDLFFBQVEsVUFBUixDQUFmOztBQUVBOzs7OztBQUtBQyxPQUFPQyxPQUFQLEdBQWlCLFNBQVNDLE9BQVQsQ0FBaUJDLE9BQWpCLEVBQW1DO0FBQ2hELFFBQUksQ0FBQ0wsTUFBTCxFQUFhO0FBQ1Q7QUFDSDs7QUFFRCxRQUFJLE9BQU9NLE9BQVAsS0FBbUIsV0FBdkIsRUFBb0M7QUFBQTs7QUFBQSwwQ0FMTUMsSUFLTjtBQUxNQSxnQkFLTjtBQUFBOztBQUNoQyw2QkFBUUMsS0FBUixnQ0FBMEJILE9BQTFCLFNBQXdDRSxJQUF4QyxHQURnQyxDQUNlO0FBQ2xEOztBQUVELFFBQUk7QUFDSjtBQUNBO0FBQ0E7QUFDSSxjQUFNLElBQUlFLEtBQUosQ0FBVUosT0FBVixDQUFOO0FBQ0gsS0FMRCxDQUtFLE9BQU9LLENBQVAsRUFBVTtBQUNaO0FBQ0M7QUFDSixDQWpCRCIsImZpbGUiOiJ3YXJuaW5nLmpzIiwic291cmNlc0NvbnRlbnQiOlsiY29uc3QgSVNfREVWID0gcmVxdWlyZSgnLi9pcy1kZXYnKTtcblxuLyoqXG4gKiBMb2cgYSBkZXZlbG9wbWVudCB3YXJuaW5nLlxuICogQHBhcmFtIHtTdHJpbmd9IG1lc3NhZ2VcbiAqL1xuXG5tb2R1bGUuZXhwb3J0cyA9IGZ1bmN0aW9uIHdhcm5pbmcobWVzc2FnZSwgLi4ubW9yZSkge1xuICAgIGlmICghSVNfREVWKSB7XG4gICAgICAgIHJldHVybjtcbiAgICB9XG5cbiAgICBpZiAodHlwZW9mIGNvbnNvbGUgIT09ICd1bmRlZmluZWQnKSB7XG4gICAgICAgIGNvbnNvbGUuZXJyb3IoYFdhcm5pbmc6ICR7bWVzc2FnZX1gLCAuLi5tb3JlKTsgLy8gZXNsaW50LWRpc2FibGUtbGluZSBuby1jb25zb2xlXG4gICAgfVxuXG4gICAgdHJ5IHtcbiAgICAvLyAtLS0gV2VsY29tZSB0byBkZWJ1Z2dpbmcgU2xhdGUgLS0tXG4gICAgLy8gVGhpcyBlcnJvciB3YXMgdGhyb3duIGFzIGEgY29udmVuaWVuY2Ugc28gdGhhdCB5b3UgY2FuIHVzZSB0aGlzIHN0YWNrXG4gICAgLy8gdG8gZmluZCB0aGUgY2FsbHNpdGUgdGhhdCBjYXVzZWQgdGhpcyB3YXJuaW5nIHRvIGZpcmUuXG4gICAgICAgIHRocm93IG5ldyBFcnJvcihtZXNzYWdlKTtcbiAgICB9IGNhdGNoICh4KSB7XG4gICAgLy8gVGhpcyBlcnJvciBpcyBvbmx5IGZvciBkZWJ1Z2dpbmdcbiAgICB9XG59O1xuIl19