'use strict';

var React = require('react');
var classNames = require('classnames');

var Pagination = React.createClass({
    displayName: 'Pagination',

    propTypes: {
        // Index of current page
        page: React.PropTypes.number.isRequired,

        // Total count of pages
        pages: React.PropTypes.number.isRequired,

        // Minimum number of pages to list
        pagesToList: React.PropTypes.number,

        // Callback when page changed (optional)
        onChange: React.PropTypes.func,

        // Current uri
        getURL: React.PropTypes.func
    },

    getDefaultProps: function getDefaultProps() {
        return {
            getURL: function getURL(page) {
                return '?page=' + page;
            },
            pagesToList: 5
        };
    },


    /**
     * Clicked to select a page
     * @param  {Number} i
     */
    onSelectPage: function onSelectPage(i, e) {
        if (this.props.onChange) {
            e.preventDefault();
            return this.props.onChange(i);
        }
    },


    /**
     * Render a page selector
     * @param {Number} i
     * @param {String} text
     * @return {React.Element}
     */
    renderPageItem: function renderPageItem(i, text) {
        var page = this.props.page;
        var isActive = i === page;
        var className = classNames({
            active: isActive
        });
        var uri = this.props.getURL(i);

        return React.createElement(
            'li',
            { key: i, className: className },
            React.createElement(
                'a',
                { href: uri, onClick: this.onSelectPage.bind(this, i) },
                text || i + 1
            )
        );
    },
    render: function render() {
        var page = this.props.page;
        var pages = this.props.pages;
        var pagesToList = this.props.pagesToList;

        if (pages < 2) {
            return React.createElement('div', null);
        }

        var maxPage = pages - 1;
        if (page < 0) page = 0;
        if (page > maxPage) page = maxPage;

        // startRange, inclusive
        var startRange = Math.max(0, page - pagesToList);
        // endRange, inclusive
        var endRange = Math.min(maxPage, page + pagesToList);
        // All the displayed page numbers
        var pagesRange = Array.from(Array(pages)).map(Number.call, Number).slice(startRange, endRange + 1);

        return React.createElement(
            'div',
            { className: 'pagination' },
            React.createElement(
                'ul',
                { className: 'pagination-pages' },
                startRange === 0 ? '' : this.renderPageItem(0),
                startRange === 0 ? '' : React.createElement(
                    'li',
                    null,
                    React.createElement(
                        'span',
                        { className: 'separator' },
                        '...'
                    )
                ),
                pagesRange.map(function (i) {
                    return this.renderPageItem(i);
                }, this),
                endRange === maxPage ? '' : React.createElement(
                    'li',
                    null,
                    React.createElement(
                        'span',
                        { className: 'separator' },
                        '...'
                    )
                ),
                endRange === maxPage ? '' : this.renderPageItem(maxPage)
            ),
            React.createElement(
                'ul',
                { className: 'pagination-nav' },
                page < 1 ? '' : this.renderPageItem(page - 1, '« previous page'),
                page >= maxPage - 1 ? '' : this.renderPageItem(page + 1, 'next page »')
            )
        );
    }
});

module.exports = Pagination;
//# sourceMappingURL=data:application/json;base64,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