"use strict";

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var React = require('react');

/**
 * Component to represent a scrollable content,
 * scroll position can be set as a percent.
 *
 * @type {ReactType}
 */
var ScrollArea = React.createClass({
    displayName: "ScrollArea",

    propTypes: {
        children: React.PropTypes.node,
        // Position of scrolling
        top: React.PropTypes.number,
        // Debouncing interval
        debouncing: React.PropTypes.number,
        // When scrolling
        onScroll: React.PropTypes.func
    },

    getDefaultProps: function getDefaultProps() {
        return {
            debouncing: 5
        };
    },
    onDebouncedScroll: function onDebouncedScroll(e) {
        var onScroll = this.props.onScroll;

        var container = this.refs.scroller;

        if (!container || !onScroll) {
            return;
        }

        var scrollPercentage = container.scrollTop / (container.scrollHeight - container.offsetHeight);
        if (scrollPercentage > 1) {
            scrollPercentage = 1;
        } else if (scrollPercentage < 0) {
            scrollPercentage = 0;
        }

        onScroll(scrollPercentage);
    },
    onScroll: function onScroll(e) {
        var _this = this;

        var debouncing = this.props.debouncing;

        this.cancelDebouncing();
        this.timeout = setTimeout(function () {
            return _this.onDebouncedScroll(e);
        }, debouncing);
    },
    cancelDebouncing: function cancelDebouncing() {
        if (this.timeout) {
            clearTimeout(this.timeout);
        }
    },
    setScroll: function setScroll() {
        var top = this.props.top;

        var container = this.refs.scroller;

        if (container) {
            container.scrollTop = top * (container.scrollHeight - container.offsetHeight);
        }
    },
    componentDidUpdate: function componentDidUpdate(prevProps) {
        if (prevProps.top == this.props.top) {
            return;
        }

        this.setScroll();
    },
    componentDidMount: function componentDidMount() {
        this.setScroll();
    },
    componentWillUnmount: function componentWillUnmount() {
        this.cancelDebouncing();
    },
    render: function render() {
        var _props = this.props,
            children = _props.children,
            props = _objectWithoutProperties(_props, ["children"]);

        return React.createElement(
            "div",
            _extends({
                ref: "scroller",
                className: "ScrollArea",
                onScroll: this.onScroll
            }, props),
            children
        );
    }
});

module.exports = ScrollArea;
//# sourceMappingURL=data:application/json;base64,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