'use strict';

var React = require('react');
var classNames = require('classnames');

var SIZES = require('./SIZES');

/**
 * An icon using an internal SVG.
 *
 * @type {ReactClass}
 */
var SVGIcon = React.createClass({
    displayName: 'SVGIcon',

    propTypes: {
        svg: React.PropTypes.string,
        className: React.PropTypes.string,
        size: React.PropTypes.oneOf(SIZES)
    },

    getDefaultProps: function getDefaultProps() {
        return {
            size: 'sm'
        };
    },
    render: function render() {
        var _props = this.props,
            svg = _props.svg,
            size = _props.size,
            className = _props.className;

        var cl = classNames('Icon', 'SVGIcon', 'size-' + size, className);

        return React.createElement('span', { className: cl, dangerouslySetInnerHTML: { __html: svg } });
    }
});

module.exports = SVGIcon;
//# sourceMappingURL=data:application/json;base64,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