'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('react');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Modal = require('../src/Modal');
var Button = require('../src/Button');
var Backdrop = require('../src/Backdrop');

var SCOPE = { React: React, Modal: Modal, Button: Button, Backdrop: Backdrop };

var EXAMPLE_IMPORT = 'const Modal = require(\'gitbook-styleguide/lib/Modal\');';

var EXAMPLE_DEFAULT = '<Modal animated={false}>\n    <Modal.Heading title="Title" />\n    <Modal.Body>\n        Body of the modal\n    </Modal.Body>\n    <Modal.Footer>\n        <Button style="secondary">Cancel</Button>\n        <Button style="primary">Important action</Button>\n    </Modal.Footer>\n</Modal>';

var EXAMPLE_BACKDROP = '\n<Button onClick={event => this.setState({ open: true })}>Open modal</Button>\n{this.state.open ?\n    <Backdrop wrapper={<Modal.Backdrop />} onClose={event => this.setState({ open: false })}>\n        <Modal>\n            <Modal.Heading title="Title" />\n            <Modal.Body>\n                Body of the modal\n            </Modal.Body>\n            <Modal.Footer>\n                <Button style="secondary" onClick={event => this.setState({ open: false })}>Cancel</Button>\n                <Button style="primary">Important action</Button>\n            </Modal.Footer>\n        </Modal>\n    </Backdrop>\n: null}';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Modals', active: 'modals' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Modals' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(
                    'p',
                    null,
                    'Modals are streamlined, but flexible, dialog prompts with the minimum required functionality and smart defaults.'
                ),
                React.createElement(CodeEditor, { source: EXAMPLE_IMPORT })
            )
        ),
        React.createElement(Example, { title: 'Example', source: EXAMPLE_DEFAULT, scope: SCOPE }),
        React.createElement(Example, { title: 'With a backdrop', source: EXAMPLE_BACKDROP, scope: SCOPE })
    );
};
//# sourceMappingURL=data:application/json;base64,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