'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var React = require('react');
var classNames = require('classnames');

var Container = React.createClass({
    displayName: 'Container',

    propTypes: {
        className: React.PropTypes.string,
        children: React.PropTypes.node,
        // No hoz padding
        fluid: React.PropTypes.bool,
        // Take all the width
        maxWidth: React.PropTypes.bool
    },

    getDefaultProps: function getDefaultProps() {
        return {
            maxWidth: false,
            fluid: false
        };
    },
    render: function render() {
        var _props = this.props,
            fluid = _props.fluid,
            className = _props.className,
            maxWidth = _props.maxWidth,
            props = _objectWithoutProperties(_props, ['fluid', 'className', 'maxWidth']);

        className = classNames('container', {
            'container-fluid': fluid,
            'container-max-width': maxWidth
        }, className);

        return React.createElement(
            'div',
            _extends({}, props, { className: className }),
            this.props.children
        );
    }
});

module.exports = Container;
//# sourceMappingURL=data:application/json;base64,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