"use strict";

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var React = require('react');

/**
 * Component to represent a scrollable content,
 * scroll position can be set as a percent.
 *
 * @type {ReactType}
 */
var ScrollArea = React.createClass({
    displayName: "ScrollArea",

    propTypes: {
        children: React.PropTypes.node,
        // Position of scrolling
        top: React.PropTypes.number,
        // Debouncing interval
        debouncing: React.PropTypes.number,
        // When scrolling
        onScroll: React.PropTypes.func
    },

    getDefaultProps: function getDefaultProps() {
        return {
            debouncing: 5
        };
    },
    onDebouncedScroll: function onDebouncedScroll(e) {
        var onScroll = this.props.onScroll;

        var container = this.refs.scroller;

        if (!container || !onScroll) {
            return;
        }

        var scrollPercentage = container.scrollTop / (container.scrollHeight - container.offsetHeight);
        if (scrollPercentage > 1) {
            scrollPercentage = 1;
        } else if (scrollPercentage < 0) {
            scrollPercentage = 0;
        }

        onScroll(scrollPercentage);
    },
    onScroll: function onScroll(e) {
        var _this = this;

        var debouncing = this.props.debouncing;

        this.cancelDebouncing();
        this.timeout = setTimeout(function () {
            return _this.onDebouncedScroll(e);
        }, debouncing);
    },
    cancelDebouncing: function cancelDebouncing() {
        if (this.timeout) {
            clearTimeout(this.timeout);
        }
    },
    setScroll: function setScroll() {
        var top = this.props.top;

        var container = this.refs.scroller;

        if (container) {
            container.scrollTop = top * (container.scrollHeight - container.offsetHeight);
        }
    },
    componentDidUpdate: function componentDidUpdate(prevProps) {
        if (prevProps.top == this.props.top) {
            return;
        }

        this.setScroll();
    },
    componentDidMount: function componentDidMount() {
        this.setScroll();
    },
    componentWillUnmount: function componentWillUnmount() {
        this.cancelDebouncing();
    },
    render: function render() {
        var _props = this.props,
            children = _props.children,
            props = _objectWithoutProperties(_props, ["children"]);

        delete props.top;
        delete props.debouncing;
        delete props.onScroll;

        return React.createElement(
            "div",
            _extends({
                ref: "scroller",
                className: "ScrollArea",
                onScroll: this.onScroll
            }, props),
            children
        );
    }
});

module.exports = ScrollArea;
//# sourceMappingURL=data:application/json;base64,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