webpackHotUpdate(2,{

/***/ 752:
/***/ function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var React = __webpack_require__(2);
var ReactDOM = __webpack_require__(43);
var classNames = __webpack_require__(12);

var Backdrop = __webpack_require__(418);

var MENU_RIGHT_SPACING = 300;
var MENU_BOTTOM_SPACING = 160;

/**
 * Helper to display a context menu.
 *
 *  <ContextMenu component={() => <Dropdown></Dropdown>}>
 *    Right click here !
 *  </ContextMenu>
 *
 * @type {ReactClass}
 */
var ContextMenu = React.createClass({
    displayName: 'ContextMenu',

    propTypes: {
        component: React.PropTypes.func.isRequired,
        children: React.PropTypes.node.isRequired
    },

    getInitialState: function getInitialState() {
        return {
            open: false,
            x: 0,
            y: 0,
            directionH: 'e'
        };
    },


    /**
     * When user is opening context menu.
     */
    onOpen: function onOpen(event) {
        event.preventDefault();
        event.stopPropagation();

        var x = event.clientX;
        var y = event.clientY;

        var width = window.innerWidth;
        var height = window.innerHeight;

        this.setState({
            open: true,
            x: x,
            y: y,
            directionH: x > width - MENU_RIGHT_SPACING ? 'w' : 'e',
            directionV: y > height - MENU_BOTTOM_SPACING ? 'n' : 's'
        });
    },


    /**
     * When user is closing the menu.
     */
    onClose: function onClose() {
        this.setState({
            open: false
        });
    },
    bindEvents: function bindEvents() {
        var el = ReactDOM.findDOMNode(this);
        el.addEventListener('contextmenu', this.onOpen, false);
    },
    unbindEvents: function unbindEvents() {
        var el = ReactDOM.findDOMNode(this);
        el.removeEventListener('contextmenu', this.onOpen, false);
    },
    componentDidMount: function componentDidMount() {
        this.bindEvents();
    },
    componentWillUnmount: function componentWillUnmount() {
        this.unbindEvents();
    },
    componentWillUpdate: function componentWillUpdate() {
        this.unbindEvents();
    },
    componentDidUpdate: function componentDidUpdate() {
        this.bindEvents();
    },
    render: function render() {
        var _props = this.props,
            children = _props.children,
            component = _props.component,
            otherProps = _objectWithoutProperties(_props, ['children', 'component']);

        var _state = this.state,
            open = _state.open,
            x = _state.x,
            y = _state.y,
            directionH = _state.directionH,
            directionV = _state.directionV;


        var inner = React.Children.only(children);

        if (!open) {
            return inner;
        }

        var menu = React.createElement(component, otherProps);

        return React.createElement(
            Backdrop,
            { wrapper: inner, onClose: this.onClose },
            React.createElement(
                'div',
                { className: classNames('ContextMenu', 'direction-' + directionH, 'direction-' + directionV), style: { top: y, left: x } },
                menu
            )
        );
    }
});

module.exports = ContextMenu;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNyYy9Db250ZXh0TWVudS5qcyJdLCJuYW1lcyI6WyJSZWFjdCIsInJlcXVpcmUiLCJSZWFjdERPTSIsImNsYXNzTmFtZXMiLCJCYWNrZHJvcCIsIk1FTlVfUklHSFRfU1BBQ0lORyIsIk1FTlVfQk9UVE9NX1NQQUNJTkciLCJDb250ZXh0TWVudSIsImNyZWF0ZUNsYXNzIiwicHJvcFR5cGVzIiwiY29tcG9uZW50IiwiUHJvcFR5cGVzIiwiZnVuYyIsImlzUmVxdWlyZWQiLCJjaGlsZHJlbiIsIm5vZGUiLCJnZXRJbml0aWFsU3RhdGUiLCJvcGVuIiwieCIsInkiLCJkaXJlY3Rpb25IIiwib25PcGVuIiwiZXZlbnQiLCJwcmV2ZW50RGVmYXVsdCIsInN0b3BQcm9wYWdhdGlvbiIsImNsaWVudFgiLCJjbGllbnRZIiwid2lkdGgiLCJ3aW5kb3ciLCJpbm5lcldpZHRoIiwiaGVpZ2h0IiwiaW5uZXJIZWlnaHQiLCJzZXRTdGF0ZSIsImRpcmVjdGlvblYiLCJvbkNsb3NlIiwiYmluZEV2ZW50cyIsImVsIiwiZmluZERPTU5vZGUiLCJhZGRFdmVudExpc3RlbmVyIiwidW5iaW5kRXZlbnRzIiwicmVtb3ZlRXZlbnRMaXN0ZW5lciIsImNvbXBvbmVudERpZE1vdW50IiwiY29tcG9uZW50V2lsbFVubW91bnQiLCJjb21wb25lbnRXaWxsVXBkYXRlIiwiY29tcG9uZW50RGlkVXBkYXRlIiwicmVuZGVyIiwicHJvcHMiLCJvdGhlclByb3BzIiwic3RhdGUiLCJpbm5lciIsIkNoaWxkcmVuIiwib25seSIsIm1lbnUiLCJjcmVhdGVFbGVtZW50IiwidG9wIiwibGVmdCIsIm1vZHVsZSIsImV4cG9ydHMiXSwibWFwcGluZ3MiOiI7Ozs7QUFBQSxJQUFNQSxRQUFRQyxRQUFRLE9BQVIsQ0FBZDtBQUNBLElBQU1DLFdBQVdELFFBQVEsV0FBUixDQUFqQjtBQUNBLElBQU1FLGFBQWFGLFFBQVEsWUFBUixDQUFuQjs7QUFFQSxJQUFNRyxXQUFXSCxRQUFRLFlBQVIsQ0FBakI7O0FBRUEsSUFBTUkscUJBQXFCLEdBQTNCO0FBQ0EsSUFBTUMsc0JBQXNCLEdBQTVCOztBQUVBOzs7Ozs7Ozs7QUFTQSxJQUFNQyxjQUFjUCxNQUFNUSxXQUFOLENBQWtCO0FBQUE7O0FBQ2xDQyxlQUFXO0FBQ1BDLG1CQUFhVixNQUFNVyxTQUFOLENBQWdCQyxJQUFoQixDQUFxQkMsVUFEM0I7QUFFUEMsa0JBQVVkLE1BQU1XLFNBQU4sQ0FBZ0JJLElBQWhCLENBQXFCRjtBQUZ4QixLQUR1Qjs7QUFNbENHLG1CQU5rQyw2QkFNaEI7QUFDZCxlQUFPO0FBQ0hDLGtCQUFNLEtBREg7QUFFSEMsZUFBRyxDQUZBO0FBR0hDLGVBQUcsQ0FIQTtBQUlIQyx3QkFBWTtBQUpULFNBQVA7QUFNSCxLQWJpQzs7O0FBZWxDOzs7QUFHQUMsVUFsQmtDLGtCQWtCM0JDLEtBbEIyQixFQWtCcEI7QUFDVkEsY0FBTUMsY0FBTjtBQUNBRCxjQUFNRSxlQUFOOztBQUVBLFlBQU1OLElBQUlJLE1BQU1HLE9BQWhCO0FBQ0EsWUFBTU4sSUFBSUcsTUFBTUksT0FBaEI7O0FBRUEsWUFBTUMsUUFBUUMsT0FBT0MsVUFBckI7QUFDQSxZQUFNQyxTQUFTRixPQUFPRyxXQUF0Qjs7QUFFQSxhQUFLQyxRQUFMLENBQWM7QUFDVmYsa0JBQU0sSUFESTtBQUVWQyxnQkFGVTtBQUdWQyxnQkFIVTtBQUlWQyx3QkFBWUYsSUFBS1MsUUFBUXRCLGtCQUFiLEdBQW1DLEdBQW5DLEdBQXlDLEdBSjNDO0FBS1Y0Qix3QkFBWWQsSUFBS1csU0FBU3hCLG1CQUFkLEdBQXFDLEdBQXJDLEdBQTJDO0FBTDdDLFNBQWQ7QUFPSCxLQW5DaUM7OztBQXFDbEM7OztBQUdBNEIsV0F4Q2tDLHFCQXdDeEI7QUFDTixhQUFLRixRQUFMLENBQWM7QUFDVmYsa0JBQU07QUFESSxTQUFkO0FBR0gsS0E1Q2lDO0FBOENsQ2tCLGNBOUNrQyx3QkE4Q3JCO0FBQ1QsWUFBTUMsS0FBS2xDLFNBQVNtQyxXQUFULENBQXFCLElBQXJCLENBQVg7QUFDQUQsV0FBR0UsZ0JBQUgsQ0FBb0IsYUFBcEIsRUFBbUMsS0FBS2pCLE1BQXhDLEVBQWdELEtBQWhEO0FBQ0gsS0FqRGlDO0FBbURsQ2tCLGdCQW5Ea0MsMEJBbURuQjtBQUNYLFlBQU1ILEtBQUtsQyxTQUFTbUMsV0FBVCxDQUFxQixJQUFyQixDQUFYO0FBQ0FELFdBQUdJLG1CQUFILENBQXVCLGFBQXZCLEVBQXNDLEtBQUtuQixNQUEzQyxFQUFtRCxLQUFuRDtBQUNILEtBdERpQztBQXdEbENvQixxQkF4RGtDLCtCQXdEZDtBQUNoQixhQUFLTixVQUFMO0FBQ0gsS0ExRGlDO0FBNERsQ08sd0JBNURrQyxrQ0E0RFg7QUFDbkIsYUFBS0gsWUFBTDtBQUNILEtBOURpQztBQWdFbENJLHVCQWhFa0MsaUNBZ0VaO0FBQ2xCLGFBQUtKLFlBQUw7QUFDSCxLQWxFaUM7QUFvRWxDSyxzQkFwRWtDLGdDQW9FYjtBQUNqQixhQUFLVCxVQUFMO0FBQ0gsS0F0RWlDO0FBd0VsQ1UsVUF4RWtDLG9CQXdFekI7QUFBQSxxQkFDMEMsS0FBS0MsS0FEL0M7QUFBQSxZQUNHaEMsUUFESCxVQUNHQSxRQURIO0FBQUEsWUFDYUosU0FEYixVQUNhQSxTQURiO0FBQUEsWUFDMkJxQyxVQUQzQjs7QUFBQSxxQkFFMEMsS0FBS0MsS0FGL0M7QUFBQSxZQUVHL0IsSUFGSCxVQUVHQSxJQUZIO0FBQUEsWUFFU0MsQ0FGVCxVQUVTQSxDQUZUO0FBQUEsWUFFWUMsQ0FGWixVQUVZQSxDQUZaO0FBQUEsWUFFZUMsVUFGZixVQUVlQSxVQUZmO0FBQUEsWUFFMkJhLFVBRjNCLFVBRTJCQSxVQUYzQjs7O0FBSUwsWUFBTWdCLFFBQVFqRCxNQUFNa0QsUUFBTixDQUFlQyxJQUFmLENBQW9CckMsUUFBcEIsQ0FBZDs7QUFFQSxZQUFJLENBQUNHLElBQUwsRUFBVztBQUNQLG1CQUFPZ0MsS0FBUDtBQUNIOztBQUVELFlBQU1HLE9BQU9wRCxNQUFNcUQsYUFBTixDQUFvQjNDLFNBQXBCLEVBQStCcUMsVUFBL0IsQ0FBYjs7QUFFQSxlQUNJO0FBQUMsb0JBQUQ7QUFBQSxjQUFVLFNBQVNFLEtBQW5CLEVBQTBCLFNBQVMsS0FBS2YsT0FBeEM7QUFDSTtBQUFBO0FBQUEsa0JBQUssV0FBVy9CLFdBQVcsYUFBWCxpQkFBdUNpQixVQUF2QyxpQkFBa0VhLFVBQWxFLENBQWhCLEVBQWlHLE9BQU8sRUFBRXFCLEtBQUtuQyxDQUFQLEVBQVVvQyxNQUFNckMsQ0FBaEIsRUFBeEc7QUFDS2tDO0FBREw7QUFESixTQURKO0FBT0g7QUEzRmlDLENBQWxCLENBQXBCOztBQThGQUksT0FBT0MsT0FBUCxHQUFpQmxELFdBQWpCIiwiZmlsZSI6IkNvbnRleHRNZW51LmpzIiwic291cmNlUm9vdCI6Ii9Vc2Vycy9zYW15cGVzc2UvUHJvamVjdHMvR2l0Qm9vay9zdHlsZWd1aWRlIiwic291cmNlc0NvbnRlbnQiOlsiY29uc3QgUmVhY3QgPSByZXF1aXJlKCdyZWFjdCcpO1xuY29uc3QgUmVhY3RET00gPSByZXF1aXJlKCdyZWFjdC1kb20nKTtcbmNvbnN0IGNsYXNzTmFtZXMgPSByZXF1aXJlKCdjbGFzc25hbWVzJyk7XG5cbmNvbnN0IEJhY2tkcm9wID0gcmVxdWlyZSgnLi9CYWNrZHJvcCcpO1xuXG5jb25zdCBNRU5VX1JJR0hUX1NQQUNJTkcgPSAzMDA7XG5jb25zdCBNRU5VX0JPVFRPTV9TUEFDSU5HID0gMTYwO1xuXG4vKipcbiAqIEhlbHBlciB0byBkaXNwbGF5IGEgY29udGV4dCBtZW51LlxuICpcbiAqICA8Q29udGV4dE1lbnUgY29tcG9uZW50PXsoKSA9PiA8RHJvcGRvd24+PC9Ecm9wZG93bj59PlxuICogICAgUmlnaHQgY2xpY2sgaGVyZSAhXG4gKiAgPC9Db250ZXh0TWVudT5cbiAqXG4gKiBAdHlwZSB7UmVhY3RDbGFzc31cbiAqL1xuY29uc3QgQ29udGV4dE1lbnUgPSBSZWFjdC5jcmVhdGVDbGFzcyh7XG4gICAgcHJvcFR5cGVzOiB7XG4gICAgICAgIGNvbXBvbmVudDogICBSZWFjdC5Qcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuICAgICAgICBjaGlsZHJlbjogUmVhY3QuUHJvcFR5cGVzLm5vZGUuaXNSZXF1aXJlZFxuICAgIH0sXG5cbiAgICBnZXRJbml0aWFsU3RhdGUoKSB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBvcGVuOiBmYWxzZSxcbiAgICAgICAgICAgIHg6IDAsXG4gICAgICAgICAgICB5OiAwLFxuICAgICAgICAgICAgZGlyZWN0aW9uSDogJ2UnXG4gICAgICAgIH07XG4gICAgfSxcblxuICAgIC8qKlxuICAgICAqIFdoZW4gdXNlciBpcyBvcGVuaW5nIGNvbnRleHQgbWVudS5cbiAgICAgKi9cbiAgICBvbk9wZW4oZXZlbnQpIHtcbiAgICAgICAgZXZlbnQucHJldmVudERlZmF1bHQoKTtcbiAgICAgICAgZXZlbnQuc3RvcFByb3BhZ2F0aW9uKCk7XG5cbiAgICAgICAgY29uc3QgeCA9IGV2ZW50LmNsaWVudFg7XG4gICAgICAgIGNvbnN0IHkgPSBldmVudC5jbGllbnRZO1xuXG4gICAgICAgIGNvbnN0IHdpZHRoID0gd2luZG93LmlubmVyV2lkdGg7XG4gICAgICAgIGNvbnN0IGhlaWdodCA9IHdpbmRvdy5pbm5lckhlaWdodDtcblxuICAgICAgICB0aGlzLnNldFN0YXRlKHtcbiAgICAgICAgICAgIG9wZW46IHRydWUsXG4gICAgICAgICAgICB4LFxuICAgICAgICAgICAgeSxcbiAgICAgICAgICAgIGRpcmVjdGlvbkg6IHggPiAod2lkdGggLSBNRU5VX1JJR0hUX1NQQUNJTkcpID8gJ3cnIDogJ2UnLFxuICAgICAgICAgICAgZGlyZWN0aW9uVjogeSA+IChoZWlnaHQgLSBNRU5VX0JPVFRPTV9TUEFDSU5HKSA/ICduJyA6ICdzJ1xuICAgICAgICB9KTtcbiAgICB9LFxuXG4gICAgLyoqXG4gICAgICogV2hlbiB1c2VyIGlzIGNsb3NpbmcgdGhlIG1lbnUuXG4gICAgICovXG4gICAgb25DbG9zZSgpIHtcbiAgICAgICAgdGhpcy5zZXRTdGF0ZSh7XG4gICAgICAgICAgICBvcGVuOiBmYWxzZVxuICAgICAgICB9KTtcbiAgICB9LFxuXG4gICAgYmluZEV2ZW50cygpIHtcbiAgICAgICAgY29uc3QgZWwgPSBSZWFjdERPTS5maW5kRE9NTm9kZSh0aGlzKTtcbiAgICAgICAgZWwuYWRkRXZlbnRMaXN0ZW5lcignY29udGV4dG1lbnUnLCB0aGlzLm9uT3BlbiwgZmFsc2UpO1xuICAgIH0sXG5cbiAgICB1bmJpbmRFdmVudHMoKSB7XG4gICAgICAgIGNvbnN0IGVsID0gUmVhY3RET00uZmluZERPTU5vZGUodGhpcyk7XG4gICAgICAgIGVsLnJlbW92ZUV2ZW50TGlzdGVuZXIoJ2NvbnRleHRtZW51JywgdGhpcy5vbk9wZW4sIGZhbHNlKTtcbiAgICB9LFxuXG4gICAgY29tcG9uZW50RGlkTW91bnQoKSB7XG4gICAgICAgIHRoaXMuYmluZEV2ZW50cygpO1xuICAgIH0sXG5cbiAgICBjb21wb25lbnRXaWxsVW5tb3VudCgpIHtcbiAgICAgICAgdGhpcy51bmJpbmRFdmVudHMoKTtcbiAgICB9LFxuXG4gICAgY29tcG9uZW50V2lsbFVwZGF0ZSgpIHtcbiAgICAgICAgdGhpcy51bmJpbmRFdmVudHMoKTtcbiAgICB9LFxuXG4gICAgY29tcG9uZW50RGlkVXBkYXRlKCkge1xuICAgICAgICB0aGlzLmJpbmRFdmVudHMoKTtcbiAgICB9LFxuXG4gICAgcmVuZGVyKCkge1xuICAgICAgICBjb25zdCB7IGNoaWxkcmVuLCBjb21wb25lbnQsIC4uLm90aGVyUHJvcHMgfSA9IHRoaXMucHJvcHM7XG4gICAgICAgIGNvbnN0IHsgb3BlbiwgeCwgeSwgZGlyZWN0aW9uSCwgZGlyZWN0aW9uViB9ID0gdGhpcy5zdGF0ZTtcblxuICAgICAgICBjb25zdCBpbm5lciA9IFJlYWN0LkNoaWxkcmVuLm9ubHkoY2hpbGRyZW4pO1xuXG4gICAgICAgIGlmICghb3Blbikge1xuICAgICAgICAgICAgcmV0dXJuIGlubmVyO1xuICAgICAgICB9XG5cbiAgICAgICAgY29uc3QgbWVudSA9IFJlYWN0LmNyZWF0ZUVsZW1lbnQoY29tcG9uZW50LCBvdGhlclByb3BzKTtcblxuICAgICAgICByZXR1cm4gKFxuICAgICAgICAgICAgPEJhY2tkcm9wIHdyYXBwZXI9e2lubmVyfSBvbkNsb3NlPXt0aGlzLm9uQ2xvc2V9PlxuICAgICAgICAgICAgICAgIDxkaXYgY2xhc3NOYW1lPXtjbGFzc05hbWVzKCdDb250ZXh0TWVudScsIGBkaXJlY3Rpb24tJHtkaXJlY3Rpb25IfWAsIGBkaXJlY3Rpb24tJHtkaXJlY3Rpb25WfWApfSBzdHlsZT17eyB0b3A6IHksIGxlZnQ6IHggfX0+XG4gICAgICAgICAgICAgICAgICAgIHttZW51fVxuICAgICAgICAgICAgICAgIDwvZGl2PlxuICAgICAgICAgICAgPC9CYWNrZHJvcD5cbiAgICAgICAgKTtcbiAgICB9XG59KTtcblxubW9kdWxlLmV4cG9ydHMgPSBDb250ZXh0TWVudTtcbiJdfQ==

 ;(function register() { /* react-hot-loader/webpack */ if (process.env.NODE_ENV !== 'production') { if (typeof __REACT_HOT_LOADER__ === 'undefined') { return; } if (typeof module.exports === 'function') { __REACT_HOT_LOADER__.register(module.exports, 'module.exports', "/Users/samypesse/Projects/GitBook/styleguide/src/ContextMenu.js"); return; } for (var key in module.exports) { if (!Object.prototype.hasOwnProperty.call(module.exports, key)) { continue; } var namedExport = void 0; try { namedExport = module.exports[key]; } catch (err) { continue; } __REACT_HOT_LOADER__.register(namedExport, key, "/Users/samypesse/Projects/GitBook/styleguide/src/ContextMenu.js"); } } })();
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(0)))

/***/ }

})
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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