'use strict';

var React = require('react');
var ReactDOM = require('react-dom');

// left: 37, up: 38, right: 39, down: 40,
// spacebar: 32, pageup: 33, pagedown: 34, end: 35, home: 36
var SCROLLING_KEYS = {
    37: 1,
    38: 1,
    39: 1,
    40: 1
};

/**
 * Backdrop for modals, dropdown, popover.
 *
 *
 * For example:
 *
 * <Backdrop onClose={onClosePopover}>
 *      <Popover>...</Popover>
 * </Backdrop>
 */
var Backdrop = React.createClass({
    displayName: 'Backdrop',

    propTypes: {
        // Scroll is enabled ?
        scroll: React.PropTypes.bool,
        // Close on escape
        escape: React.PropTypes.bool,
        // Z-index for the backdrop
        zIndex: React.PropTypes.number,
        // Callback when backdrop is closed
        onClose: React.PropTypes.func.isRequired,
        children: React.PropTypes.node.isRequired,
        wrapper: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            scroll: false,
            escape: true,
            zIndex: 200,
            wrapper: React.createElement('div', null)
        };
    },
    onClose: function onClose() {
        var onClose = this.props.onClose;

        onClose();
    },


    /**
     * Clicking should close the backdrop.
     */
    onClick: function onClick(event) {
        event.stopPropagation();
        event.preventDefault();
        this.onClose();
    },


    /**
     * Escape should close the backdrop
     */
    onKeyDown: function onKeyDown(event) {
        var escape = this.props.escape;


        if (event.keyCode === 27 && escape) {
            this.onClose();
        }

        if (SCROLLING_KEYS[event.keyCode]) {
            event.preventDefault();
            return false;
        }
    },


    /**
     * Prevent scroll on wrapper itself.
     */
    onScroll: function onScroll(event) {
        var scroll = this.props.scroll;

        if (scroll) {
            return;
        }

        var container = ReactDOM.findDOMNode(this.refs.wrapper);
        var backdrop = ReactDOM.findDOMNode(this.refs.backdrop);

        if (event.target == container || event.target == backdrop) {
            event.preventDefault();
            event.stopPropagation();
        }
    },
    bindEvents: function bindEvents() {
        var container = ReactDOM.findDOMNode(this.refs.wrapper);

        window.addEventListener('keydown', this.onKeyDown);
        container.addEventListener('scroll', this.onScroll);
        container.addEventListener('wheel', this.onScroll);
    },
    unbindEvents: function unbindEvents() {
        var container = ReactDOM.findDOMNode(this.refs.wrapper);

        window.removeEventListener('keydown', this.onKeyDown);
        container.removeEventListener('scroll', this.onScroll);
        container.removeEventListener('wheel', this.onScroll);
    },
    componentDidMount: function componentDidMount() {
        this.bindEvents();
    },
    componentWillUpdate: function componentWillUpdate() {
        this.unbindEvents();
    },
    componentDidUpdate: function componentDidUpdate() {
        this.bindEvents();
    },
    componentWillUnmount: function componentWillUnmount() {
        this.unbindEvents();
    },
    render: function render() {
        var _props = this.props,
            zIndex = _props.zIndex,
            wrapper = _props.wrapper,
            children = _props.children;

        var style = {
            zIndex: zIndex,
            position: 'fixed',
            top: 0,
            right: 0,
            width: '100%',
            height: '100%'
        };

        return React.cloneElement(wrapper, { ref: 'wrapper' }, React.createElement('div', {
            className: 'Backdrop',
            ref: 'backdrop',
            style: style,
            onClick: this.onClick
        }), wrapper.props.children, children);
    }
});

module.exports = Backdrop;
//# sourceMappingURL=data:application/json;base64,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