'use strict';

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var React = require('react');
var ReactDOM = require('react-dom');
var classNames = require('classnames');

var Backdrop = require('./Backdrop');
var Dropdown = require('./Dropdown');

var MENU_RIGHT_SPACING = 300;
var MENU_BOTTOM_SPACING = 160;

/**
 * Helper to display a context menu.
 *
 *  <ContextMenu component={() => <ContextMenu.Menu></ContextMenu.Menu>}>
 *    Right click here !
 *  </ContextMenu>
 *
 * @type {ReactClass}
 */
var ContextMenu = React.createClass({
    displayName: 'ContextMenu',

    propTypes: {
        component: React.PropTypes.func.isRequired,
        children: React.PropTypes.node.isRequired
    },

    getInitialState: function getInitialState() {
        return {
            open: false,
            x: 0,
            y: 0,
            directionH: 'e',
            directionV: 's'
        };
    },


    /**
     * When user is opening context menu.
     */
    onOpen: function onOpen(event) {
        event.preventDefault();
        event.stopPropagation();

        var x = event.clientX;
        var y = event.clientY;

        var width = window.innerWidth;
        var height = window.innerHeight;

        this.setState({
            open: true,
            x: x,
            y: y,
            directionH: x > width - MENU_RIGHT_SPACING ? 'w' : 'e',
            directionV: y > height - MENU_BOTTOM_SPACING ? 'n' : 's'
        });
    },


    /**
     * When user is closing the menu.
     */
    onClose: function onClose() {
        this.setState({
            open: false
        });
    },


    /**
     * Close the menu after any click on the window.
     * We wait next event loop to avoid hiding the menu before the click got propaged to it.
     */
    onWindowClick: function onWindowClick() {
        var _this = this;

        setTimeout(function () {
            return _this.onClose();
        }, 1);
    },
    bindEvents: function bindEvents() {
        var el = ReactDOM.findDOMNode(this);
        el.addEventListener('contextmenu', this.onOpen, false);
        el.addEventListener('click', this.onWindowClick, false);
    },
    unbindEvents: function unbindEvents() {
        var el = ReactDOM.findDOMNode(this);
        el.removeEventListener('contextmenu', this.onOpen, false);
        el.removeEventListener('click', this.onWindowClick, false);
    },
    componentDidMount: function componentDidMount() {
        this.bindEvents();
    },
    componentWillUnmount: function componentWillUnmount() {
        this.unbindEvents();
    },
    componentWillUpdate: function componentWillUpdate() {
        this.unbindEvents();
    },
    componentDidUpdate: function componentDidUpdate() {
        this.bindEvents();
    },
    render: function render() {
        var _props = this.props,
            children = _props.children,
            component = _props.component,
            otherProps = _objectWithoutProperties(_props, ['children', 'component']);

        var _state = this.state,
            open = _state.open,
            x = _state.x,
            y = _state.y,
            directionH = _state.directionH,
            directionV = _state.directionV;


        var inner = React.Children.only(children);

        if (!open) {
            return inner;
        }

        var menu = React.createElement(component, otherProps);

        return React.createElement(
            Backdrop,
            { wrapper: inner, onClose: this.onClose },
            React.createElement(
                'div',
                {
                    className: classNames('ContextMenu', 'direction-' + directionH, 'direction-' + directionV),
                    style: { top: y, left: x },
                    onClick: this.onClick },
                menu
            )
        );
    }
});

module.exports = ContextMenu;
module.exports.Divider = Dropdown.Divider;
module.exports.Header = Dropdown.Header;
module.exports.Item = Dropdown.Item;
module.exports.Menu = Dropdown.Menu;
//# sourceMappingURL=data:application/json;base64,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