'use strict';

var React = require('react');

/**
 * Displays a loading bar (YouTube-like) at the top of container
 * Based on https://github.com/lonelyclick/react-loading-bar/blob/master/src/Loading.jsx
 *
 * @type {ReactClass}
 */
var LoadingBar = React.createClass({
    displayName: 'LoadingBar',

    propTypes: {
        show: React.PropTypes.bool
    },

    getDefaultProps: function getDefaultProps() {
        return {
            show: false
        };
    },
    getInitialState: function getInitialState() {
        return {
            size: 0,
            disappearDelayHide: false, // when dispappear, first transition then display none
            percent: 0,
            appearDelayWidth: 0 // when appear, first display block then transition width
        };
    },
    componentWillReceiveProps: function componentWillReceiveProps(nextProps) {
        var show = nextProps.show;


        if (show) {
            this.show();
        } else {
            this.hide();
        }
    },
    shouldComponentUpdate: function shouldComponentUpdate(nextProps, nextState) {
        return true; // !shallowEqual(nextState, this.state)
    },
    show: function show() {
        var _this = this;

        var _state = this.state,
            size = _state.size,
            percent = _state.percent;


        var appearDelayWidth = size === 0;
        percent = calculatePercent(percent);

        this.setState({
            size: ++size,
            appearDelayWidth: appearDelayWidth,
            percent: percent
        });

        if (appearDelayWidth) {
            setTimeout(function () {
                _this.setState({
                    appearDelayWidth: false
                });
            });
        }
    },
    hide: function hide() {
        var _this2 = this;

        var size = this.state.size;


        if (size < 1) {
            this.setState({ size: 0 });
            return;
        }

        this.setState({
            size: 0,
            disappearDelayHide: true,
            percent: 1
        });

        setTimeout(function () {
            _this2.setState({
                disappearDelayHide: false,
                percent: 0
            });
        }, 500);
    },
    getBarStyle: function getBarStyle() {
        var _state2 = this.state,
            disappearDelayHide = _state2.disappearDelayHide,
            appearDelayWidth = _state2.appearDelayWidth,
            percent = _state2.percent;


        return {
            width: appearDelayWidth ? 0 : percent * 100 + '%',
            display: disappearDelayHide || percent > 0 ? 'block' : 'none'
        };
    },
    getShadowStyle: function getShadowStyle() {
        var _state3 = this.state,
            percent = _state3.percent,
            disappearDelayHide = _state3.disappearDelayHide;


        return {
            display: disappearDelayHide || percent > 0 ? 'block' : 'none'
        };
    },
    render: function render() {
        return React.createElement(
            'div',
            { className: 'LoadingBar' },
            React.createElement(
                'div',
                { className: 'bar', style: this.getBarStyle() },
                React.createElement('div', { className: 'LoadingBar-shadow',
                    style: this.getShadowStyle() })
            )
        );
    }
});

function calculatePercent(percent) {
    percent = percent || 0;

    // How much of remaining bar we advance
    var progress = 0.1 + Math.random() * 0.3;

    return percent + progress * (1 - percent);
}

module.exports = LoadingBar;
//# sourceMappingURL=data:application/json;base64,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