'use strict';

var React = require('react');
var classNames = require('classnames');

var SIZES = require('./SIZES');

var Modal = React.createClass({
    displayName: 'Modal',

    propTypes: {
        size: React.PropTypes.oneOf(SIZES),
        backdrop: React.PropTypes.bool,
        animated: React.PropTypes.bool,
        children: React.PropTypes.node,
        className: React.PropTypes.string
    },

    getDefaultProps: function getDefaultProps() {
        return {
            size: 'md',
            backdrop: true,
            animated: true
        };
    },
    render: function render() {
        var _props = this.props,
            size = _props.size,
            backdrop = _props.backdrop,
            animated = _props.animated,
            children = _props.children;


        var className = classNames('modal', 'modal-' + size, this.props.className, {
            animated: animated,
            'without-backdrop': !backdrop
        });

        return React.createElement(
            'div',
            { className: className },
            children
        );
    }
});

var ModalBackdrop = React.createClass({
    displayName: 'ModalBackdrop',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'modal-backdrop' },
            this.props.children
        );
    }
});

var ModalBody = React.createClass({
    displayName: 'ModalBody',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'modal-body' },
            this.props.children
        );
    }
});

var ModalFooter = React.createClass({
    displayName: 'ModalFooter',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'modal-footer ' },
            this.props.children
        );
    }
});

var ModalHeading = React.createClass({
    displayName: 'ModalHeading',

    propTypes: {
        children: React.PropTypes.node,
        onClose: React.PropTypes.func,
        title: React.PropTypes.string
    },

    onClose: function onClose(e) {
        e.preventDefault();
        this.props.onClose();
    },
    render: function render() {
        if (this.props.title) {
            return React.createElement(
                'div',
                { className: 'modal-heading' },
                React.createElement(
                    'h4',
                    null,
                    this.props.title
                ),
                this.props.onClose ? React.createElement(
                    'a',
                    { href: '#', onClick: this.onClose, className: 'modal-close' },
                    '\xD7'
                ) : ''
            );
        }

        return React.createElement(
            'div',
            { className: 'modal-heading' },
            this.props.children
        );
    }
});

module.exports = Modal;
module.exports.Backdrop = ModalBackdrop;
module.exports.Body = ModalBody;
module.exports.Footer = ModalFooter;
module.exports.Heading = ModalHeading;
//# sourceMappingURL=data:application/json;base64,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