'use strict';

var React = require('react');
var classNames = require('classnames');
var SIZES = require('./SIZES');

var Row = React.createClass({
    displayName: 'Row',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'row' },
            this.props.children
        );
    }
});

var Container = require('./Container');

var Column = React.createClass({
    displayName: 'Column',

    propTypes: {
        children: React.PropTypes.node,
        className: React.PropTypes.string
    },

    render: function render() {
        var _this = this;

        var _props = this.props,
            children = _props.children,
            className = _props.className;


        var cl = classNames(className, SIZES.reduce(function (list, size) {
            var col = _this.props[size];
            var offset = _this.props[size + 'Offset'];

            if (col) {
                list.push(['col', size, col].join('-'));
            }
            if (offset) {
                list.push(['col', size, 'offset', offset].join('-'));
            }

            return list;
        }, []));

        return React.createElement(
            'div',
            { className: cl },
            children
        );
    }
});

module.exports = Row;
module.exports.Container = Container;
module.exports.Col = Column;
//# sourceMappingURL=data:application/json;base64,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