'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('react');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Dropdown = require('../src/Dropdown');
var Button = require('../src/Button');
var ContextMenu = require('../src/ContextMenu');
var Icon = require('../src/Icon');

var SCOPE = { React: React, Dropdown: Dropdown, Button: Button, Icon: Icon, ContextMenu: ContextMenu };

var EXAMPLE_IMPORT = 'const Dropdown = require(\'gitbook-styleguide/lib/Dropdown\')';
var EXAMPLE_DEFAULT = '<Dropdown>\n    <Button>\n        Toggle dropdown <Button.Caret />\n    </Button>\n    <Dropdown.Header>Account</Dropdown.Header>\n    <Dropdown.Item href="/profile">Profile</Dropdown.Item>\n    <Dropdown.Item href="/settings">Settings</Dropdown.Item>\n    <Dropdown.Divider />\n    <Dropdown.Item onClick={e => alert(\'Logout\')}>Logout</Dropdown.Item>\n</Dropdown>';

var EXAMPLE_CONTEXTMENU = '<ContextMenu component={() => (\n    <ContextMenu.Menu>\n        <ContextMenu.Header>Account</ContextMenu.Header>\n        <ContextMenu.Item href="/profile">Profile</ContextMenu.Item>\n        <ContextMenu.Item href="/settings">Settings</ContextMenu.Item>\n        <ContextMenu.Divider />\n        <ContextMenu.Item onClick={e => alert(\'Logout\')}>Logout</ContextMenu.Item>\n    </ContextMenu.Menu>\n)}>\n    <div>Left click</div>\n</ContextMenu>';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Dropdowns', active: 'dropdowns' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Dropdowns' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(CodeEditor, { source: EXAMPLE_IMPORT })
            )
        ),
        React.createElement(Example, { title: 'Default', source: EXAMPLE_DEFAULT, scope: SCOPE }),
        React.createElement(Example, { title: 'Context Menu', source: EXAMPLE_CONTEXTMENU, scope: SCOPE })
    );
};
//# sourceMappingURL=data:application/json;base64,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