'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('react');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Form = require('../src/Form');
var Icon = require('../src/Icon');
var Input = require('../src/Input');
var Button = require('../src/Button');
var Select = require('../src/Select');
var Checkbox = require('../src/Checkbox');
var Textarea = require('../src/Textarea');

var SCOPE = { React: React, Form: Form, Input: Input, Icon: Icon, Button: Button, Select: Select, Checkbox: Checkbox, Textarea: Textarea };

var EXAMPLE_IMPORT = 'const Form = require(\'gitbook-styleguide/lib/Form\');\nconst Input = require(\'gitbook-styleguide/lib/Input\');';

var EXAMPLE_DEFAULT = '<Form>\n    <Form.Group>\n        <label>Name</label>\n        <Input name="name" placeholder="John" />\n    </Form.Group>\n    <Form.Group>\n        <label>Email address</label>\n        <Input name="email" placeholder="john@doe.com" />\n    </Form.Group>\n    <Form.Group>\n        <label>Message</label>\n        <Textarea placeholder="Some message" />\n    </Form.Group>\n    <Form.Actions>\n        <Button type="submit" style="primary">Submit</Button>\n        <Button type="cancel" style="secondary">Cancel</Button>\n    </Form.Actions>\n</Form>';

var EXAMPLE_SIZES = '<Input size="lg" placeholder="Large input" />\n<Input size="md" placeholder="Normal input" />\n<Input size="sm" placeholder="Small input" />\n<Input size="xs" placeholder="Extra small input" />';

var EXAMPLE_SELECT = '<Select\n    name="language"\n    search={false}\n    options={[\n        \'French\',\n        \'English\'\n    ]}\n/>';

var EXAMPLE_STATES = '<Form>\n    <Form.Group error>\n        <label>Name</label>\n        <Input name="name" placeholder="This field has an error" />\n    </Form.Group>\n    <Form.Group>\n        <label>Email address</label>\n        <Input name="email" disabled placeholder="This field is disabled" />\n    </Form.Group>\n    <Form.Group>\n        <label>Email address</label>\n        <Input name="email" focus placeholder="This field is focus" />\n    </Form.Group>\n    <Form.Group>\n        <label>Email address</label>\n        <Input name="email" readOnly placeholder="This field is read only" />\n    </Form.Group>\n</Form>';

var EXAMPLE_CHECKBOX = '<Form>\n    <Checkbox name="something" checked>\n        Something to check (with control state)\n    </Checkbox>\n    <Checkbox name="something" size="lg">\n        Something to check (Large)\n    </Checkbox>\n    <Checkbox name="something" direction="right">\n        Something to check (On the right)\n    </Checkbox>\n</Form>';

var EXAMPLE_INPUTGROUP = '<Form>\n    <Form.Group>\n        <label>Email address</label>\n        <Input.Group>\n            <Input.GroupAddon>\n                @\n            </Input.GroupAddon>\n            <Input name="email" placeholder="Enter an email" />\n        </Input.Group>\n    </Form.Group>\n</Form>';

var EXAMPLE_SELECT_COMPLEX = '<Select\n    name="countries"\n    filter={(query, option) => option.label.indexOf(query) >= 0}\n    component={({option}) => <span>{option.label}</span>}\n    options={[\n        { id: \'US\', label: \'United States\' },\n        { id: \'FR\', label: \'France\' },\n        { id: \'UK\', label: \'United Kingdom\' }\n    ]}\n/>';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Forms and Inputs', active: 'forms' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Forms and Inputs' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(
                    'p',
                    null,
                    'These components are the basic building blocks for creating forms.',
                    ' ',
                    'Each of these elements can be used individually throughout the site,',
                    ' ',
                    'however it\'s recommended to use the field components when building forms',
                    ' ',
                    'in order to take advantage of their accessibility and responsive features.'
                ),
                React.createElement(CodeEditor, { source: EXAMPLE_IMPORT })
            )
        ),
        React.createElement(Example, { title: 'Layout', source: EXAMPLE_DEFAULT, scope: SCOPE }),
        React.createElement(
            Example,
            { title: 'Sizing', source: EXAMPLE_SIZES, scope: SCOPE },
            'Make inputs smaller, larger, or full-width with an additional property.'
        ),
        React.createElement(
            Example,
            { title: 'States', source: EXAMPLE_STATES, scope: SCOPE },
            'States can be used to signal an error on a field.'
        ),
        React.createElement(Example, { title: 'Checkbox', source: EXAMPLE_CHECKBOX, scope: SCOPE }),
        React.createElement(
            Example,
            { title: 'Input Groups', source: EXAMPLE_INPUTGROUP, scope: SCOPE },
            'Extend form controls by adding text or buttons before, after, or on both sides of any text-based input.'
        ),
        React.createElement(
            Example,
            { title: 'Select', source: EXAMPLE_SELECT, scope: SCOPE },
            'HTML select are replaced by an input allowing more options (search, multiple values, custom renderers with icons, etc).'
        ),
        React.createElement(
            Example,
            { title: 'Complex Select', source: EXAMPLE_SELECT_COMPLEX, scope: SCOPE },
            React.createElement(
                'code',
                null,
                'Select'
            ),
            ' has different properties for customizing the rendering and the behaviour.'
        )
    );
};
//# sourceMappingURL=data:application/json;base64,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